<?php

class ArtMeta
{
    public static function getMetaTitle($object = null)
    {
        if (!is_null($object) && $object->getMetaTitle() != '')
            return $object->getMetaTitle();
        else {
            $response = sfContext::getInstance()->getResponse()->getMetas();

            return isset($response['title']) ? $response['title'] : '';
        }
    }

    public static function getMetaDescription($object = null)
    {
        if (!is_null($object) && $object->getMetaDescription() != '')
            return $object->getMetaDescription();
        else {
            $response = sfContext::getInstance()->getResponse()->getMetas();

            return isset($response['description']) ? $response['description'] : '';
        }
    }

    public static function getMetaKeywords($object = null)
    {
        if (!is_null($object) && $object->getMetaKeywords() != '')
            return $object->getMetaKeywords();
        else {
            $response = sfContext::getInstance()->getResponse()->getMetas();

            return isset($response['keywords']) ? $response['keywords'] : '';
        }
    }

    public static function tagsForImage(Article $article)
    {
        return ArtMeta::getMetaTitle($article) . ' ' . ArtMeta::getMetaDescription($article) . ' ' . ArtMeta::getMetaKeywords($article);
    }
}