<?php
/**
 * Description of PolishSearchableAnalyzer
 *
 
 */
class PolishSearchableAnalyzer extends Doctrine_Search_Analyzer_Standard
{

    public function analyze($text, $encoding = null)
    {
        self::$_stopwords = array();

        if (is_null($encoding)) {
            $encoding = isset($this->_options['encoding']) ? $this->_options['encoding'] : 'utf-8';
        }

        // check that $text encoding is utf-8, if not convert it
        if (strcasecmp($encoding, 'utf-8') != 0 && strcasecmp($encoding, 'utf8') != 0)
            $text = iconv($encoding, 'UTF-8', $text);

        $text = strip_tags($text);

        $text = preg_replace("/&#?[a-z0-9]{2,8};/i", "", $text);
        $text = str_replace(array(',', '.', ';', '"'), array('', '', '', ''), $text);

        $text = artStringConverter::noPolishChars($text);

        $terms = explode(' ', $text);

        $ret = array();

        if (!empty($terms)) {
            foreach ($terms as $i => $term) {
                if (empty($term)) {
                    continue;
                }
                $lower = mb_strtolower(trim($term), 'UTF-8');

                if (in_array($lower, self::$_stopwords)) {
                    continue;
                }

                $ret[$i] = $lower;
            }
        }

        return $ret;
    }

}
