<?php


class Slug {

  /**
   * @param array $array
   * @return array
   */
  static public function slugifyArray(array $array) {
    foreach ($array as $key => $value)
      $array[$key] = self::slugify($value);

    return $array;
  }

  /**
   * @param $text
   * @param string $trimSign
   * @return mixed|string
   */
  static public function slugify($text, $trimSign = '-') {
    // replace non letter or digits by -
    $text = preg_replace('~[^\\pL\d]+~u', $trimSign, $text);

    // trim
    $text = trim($text, $trimSign);

    // transliterate
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

    // lowercase
    $text = strtolower($text);

    // remove unwanted characters
    $text = preg_replace('~[^-\w]+~', '', $text);

    if (empty($text))
      return md5('n-a'.rand()); // Generuj losowy 
//      return 'n-a';

    return $text;
  }

  public static function slugifySchema($text) {
    return self::slugify($text);
  }

  public static function slugifySchemaArticle($text, $object, $count = 0) {
   
    if ($count > 0) {
      $slug = self::slugify($text.'-'.$count);
    } else {
      $slug = self::slugify($text);
    }
    
    $testArticle = Doctrine::getTable('Article')
            ->createQuery('a')
            ->leftJoin('a.Translation at')
            ->where('at.slug = ?', $slug)
            ->andWhere('a.id <> ?', $object->get('id'))
            ->execute();
    
    if ($testArticle->count() > 0 ) {
      $count++;
      return self::slugifySchemaArticle($text, $object, $count);
    }
    
    $testCategory = Doctrine::getTable('Category')
            ->createQuery('c')
            ->leftJoin('c.Translation ct')
            ->where('ct.slug = ?', $slug)
            ->execute();
    
    if ($testCategory->count() > 0 ) {
      $count++;
      return self::slugifySchemaArticle($text, $object, $count); 
    }

    return $slug;
  }
          
  public static function slugifySchemaCategory($text, $object, $count = 0) {
    
    if ($count > 0) {
      $slug = self::slugify($text.'-'.$count);
    } else {
      $slug = self::slugify($text);
    }
    
    $testCategory = Doctrine::getTable('Category')
            ->createQuery('c')
            ->leftJoin('c.Translation ct')
            ->where('ct.slug = ?', $slug)
            ->andWhere('c.id <> ?', $object->get('id'))
            ->execute();
    
    if ($testCategory->count() > 0 ) {
      $count++;
      return self::slugifySchemaCategory($text, $object, $count); 
    }
    
    $testArticle = Doctrine::getTable('Article')
            ->createQuery('a')
            ->leftJoin('a.Translation at')
            ->where('at.slug = ?', $slug)
            ->execute();
    
    if ($testArticle->count() > 0 ) {
      $count++;
      return self::slugifySchemaCategory($text, $object, $count);
    }

    return $slug;
  }

  /**
   * Tworzy sluga, zostawiając wielkie litery.
   *
   * @param $text
   * @param string $trimSign
   * @return mixed|string
   */
  static public function makeSlug($text, $trimSign = '') {
    // replace non letter or digits by
    $text = preg_replace('~[^\\pL\d]+~u', $trimSign, $text);

    // trim
    $text = trim($text, $trimSign);

    // transliterate
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);


    // remove unwanted characters
    $text = preg_replace('~[^-\w]+~', '', $text);

    if (empty($text))
      return md5('n-a'.rand()); // Generuj losowy 

    return $text;
  }

}
