<?php

/**
 * Description of artArray
 *
 
 */
class artArray
{

    /**
     * funkcja sprawdza, czy dana tablica jest pusta (nie licząc kluczy o wartościach podanych jako drugi parameter)
     * @param type $array
     * @param type $keys
     * @return type
     */
    public static function emptyExceptKeys($array, $keys)
    {
        foreach ($keys as $key)
            if (isset($array[$key]))
                unset($array[$key]);

        return empty($array);
    }

    /**
     * funkcja pomocnicza, pobierająca wartość klucza $value z tablicy - jeżeli nie istnieje klucz, zwraca $default
     * @param type $array
     * @param type $value
     * @param type $default
     * @return type
     */
    public static function getFromArray($array, $value, $default = '')
    {
        if (isset($array[$value]))
            return $array[$value];
        else
            return $default;
    }

    public static function setDefaultIfNotExists(&$arrayName, $keyName, $defaultIfNotExists = null)
    {
        if (!isset($arrayName[$keyName]))
            $arrayName[$keyName] = $defaultIfNotExists;

        return $arrayName[$keyName];
    }


    /**
     * Custom implementation of array_merge_recursive(). By default PHP's method will *not* replace existing value if key exists, instead append to that array.
     * This implementation will *replace* it, thats what we need to do.
     *
     * @link http://www.php.net/manual/en/function.array-merge-recursive.php#106985
     * @params array $n N number of arrays.
     * @return array Merged arrays.
     */
    public static function array_merge_recursive_replace()
    {
        $arrays = func_get_args();
        $base = array_shift($arrays);
        foreach ($arrays as $array) {
            reset($base);
            while (list($key, $value) = @each($array)) {
                if (is_array($value) && @is_array($base[$key])) {
                    $base[$key] = self::array_merge_recursive_replace($base[$key], $value);
                } else {
                    $base[$key] = $value;
                }
            }
        }
        return $base;
    }
}
