<?php

class artDebug
{

    public static $slots = 1;

    /**
     * Return var_dump(@param $param) with tag '<pre>' for better see
     * @param all $param
     *
     */
    public static function var_dump()
    {
        if (sfConfig::get('sf_show_var_dump', true)) {
            foreach (func_get_args() as $argument) {
                echo '<pre>';
                var_dump($argument);
                echo '</pre>';
            }
        }
    }

    public static function getVarDump()
    {
        $print = '';

        foreach (func_get_args() as $argument)
            $print .= '<pre>' . print_r($argument, true) . '</pre>';

        return $print;
    }

    public static function var_dump_doctrine()
    {
        foreach (func_get_args() as $argument) {
            artEscaper::escape($argument);

            if ($argument instanceof sfDoctrineRecord || $argument instanceof Doctrine_Collection)
                self::var_dump($argument->toArray());
            else
                self::var_dump($argument);
        }
    }

    public static function var_dump_slot()
    {
        sfContext::getInstance()->getConfiguration()->loadHelpers(array('ArteneoPartial'));

        sfConfig::set('sf_logging_enabled', false);

        slot('var_dump' . self::$slots);
        foreach (func_get_args() as $argument)
            self::var_dump_doctrine($argument);
        end_slot();

        sfConfig::set('sf_logging_enabled', true);
        self::$slots++;
    }

    public static function getSlots()
    {
        if (sfConfig::get('sf_show_var_dump', true)) {
            sfConfig::set('sf_logging_enabled', false);

            for ($i = 1; $i < self::$slots; $i++)
                include_slot('var_dump' . $i);

            sfConfig::set('sf_logging_enabled', true);
        }
    }

    public static function logError($message)
    {
        if (sfConfig::get('sf_art_log', true))
            sfContext::getInstance()->getLogger()->err("##art " . $message);
    }

    public static function logAlert($message)
    {
        if (sfConfig::get('sf_art_log', true))
            sfContext::getInstance()->getLogger()->alert("##art " . $message);
    }

    public static function logNotice($message)
    {
        if (sfConfig::get('sf_art_log', true))
            sfContext::getInstance()->getLogger()->notice("##art " . $message);
    }

    public static function logDebug($message)
    {
        if (sfConfig::get('sf_art_log', true))
            sfContext::getInstance()->getLogger()->debug("##art " . $message);
    }

    public static function logEmergency($message)
    {
        if (sfConfig::get('sf_art_log', true))
            sfContext::getInstance()->getLogger()->emerg("##art " . $message);
    }

    public static function logCritical($message)
    {
        if (sfConfig::get('sf_art_log', true))
            sfContext::getInstance()->getLogger()->crit("##art " . $message);
    }

    public static function logWarning($message)
    {
        if (sfConfig::get('sf_art_log', true))
            sfContext::getInstance()->getLogger()->warning("##art " . $message);
    }

}