<?php
/**
 * Description of artImage
 *
 
 */
class artImage
{
    const _IMAGICK_CROP_HEIGHT = 'convert %original% -thumbnail %width%x%height%^ -crop %sizes% %new%';
    const _IMAGICK_CROP_WIDTH = 'convert %original% -thumbnail %width%^x%height% -crop %sizes% %new%';
    const _IMAGICK_EXTEND_HEIGHT = 'convert %original% -thumbnail %width%x%height%^ -extent %sizes% %new%';
    const _IMAGICK_EXTEND_WIDTH = 'convert %original% -thumbnail %width%^x%height% -extent %sizes% %new%';
    const _IMAGICK_KEEP_HEIGHT = 'convert %original% -thumbnail %width%x%height%^ %new%';
    const _IMAGICK_KEEP_WIDTH = 'convert %original% -thumbnail %width%^x%height% %new%';
    const _IMAGICK_TO_SQUARE = 'convert %original% -thumbnail %width%x%height%\> %new%';

    public static function resizeImage($from, $to, $sizeX, $sizeY = null)
    {
        if (is_null($sizeY))
            $sizeY = $sizeX;

        passthru("convert " . $from . " -thumbnail " . $sizeX . "x" . $sizeY . "^ " . $to);
    }

    public static function getResizedDimensions($width, $height, $maxHeight, $maxWidth = null)
    {
        if (is_null($maxWidth))
            $maxWidth = $maxHeight;

        $dimensions = array();

        if ($height > $width) {
            $dimensions['height'] = $maxHeight;
            $dimensions['width'] = round($width * ($maxHeight / $height));

            if ($dimensions['width'] > $maxWidth) {
                $dimensions['height'] = $dimensions['height'] * ($maxWidth / $dimensions['width']);
                $dimensions['width'] = $maxWidth;
            }
        } else {
            $dimensions['width'] = $maxWidth;
            $dimensions['height'] = round($height * ($maxWidth / $width));

            if ($dimensions['height'] > $maxHeight) {
                $dimensions['width'] = $dimensions['width'] * ($maxHeight / $dimensions['height']);
                $dimensions['height'] = $maxHeight;
            }
        }

        return $dimensions;
    }

}
