<?php
/**
 * Class with function operating on roman numbers
 */
class artNumber
{

    protected static $roman = array('I', 'V', 'X', 'C', 'M', 'L');

    /**
     * Check if string is starting from the Roman Number
     * @param string @string
     */
    public static function checkIfRomanStart($string)
    {
        for ($i = 0; $i < strlen($string); $i++) {
            if ($string[$i] === ' ')
                return false;
            if (self::checkRomanEqual(strtoupper($string[$i])) === TRUE) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }

    /**
     * Check if char is equal to romanian number
     *
     * @param Char $char
     */
    public static function checkRomanEqual($char)
    {
        foreach (self::$roman as $roma)
            if ($char == $roma)
                return TRUE;
    }

    public static function canParseInt($string)
    {
        if (preg_match('/(\d+)/', $string))
            return true;
        else
            return false;
    }

    public static function parseInt($string)
    {
        if (preg_match('/(\d+)/', $string, $array))
            return $array[1];
        else
            return false;
    }

    public static function getAvg($fields)
    {
        $result = array_sum($fields) / count($fields);
        return number_format($result, 2, '.', '');
    }
    
    /**
     * Zwraca kwote w notacji polskiej.
     * 1234.56 -> 1 234,56
     * 
     * @param float $kwota Kwota
     * @return float 
     */
    public static function getKwotaNotacjaPolska($kwota) {
      return number_format($kwota, 2, ',', ' ');
    }
}

?>
