<?php

/**
 * Base class for processing patterns with given filters
 *
 
 * @copyright ArteneoIT
 */
class artQuery
{

    /**
     * Function do leftJoin with given table by relation and root alias.
     * It also join with Translation table if $translationAlias given.
     * You can override $query->getRootAlias() by specifing $rootAlias
     *
     * @param string $relation relation name connected with rootAlias
     * @param string $query query to leftJoin
     * @param string $alias alias for given join
     * @param string $translationAlias alias for translation table
     * @param string $rootAlias root alias
     */
    public static function addToQuery($relation, $query, $alias, $translationAlias = '', $rootAlias = '')
    {
        if ($rootAlias == '')
            $rootAlias = $query->getRootAlias();
        $query->leftJoin($rootAlias . '.' . $relation . ' ' . $alias);
        if ($translationAlias != '')
            $query->leftJoin($alias . '.Translation ' . $translationAlias);
        return $query;
    }

    public static function executeSql($sql)
    {
        $connection = Doctrine_Manager::getInstance()->connection();

        return $connection->execute($sql);
    }

    /*
     * Executes sql query and returns an array
     */
    public static function executeRawSql($sql)
    {
        return SqlRaw::execute($sql);
    }

}
