<?php
/**
 * Klasa która definuje metody przekierowań.
 *
 */
class BaseRedirector
{

    /**
     * @param $redirect
     * @param array $params
     * @return mixed
     */
    public static function get($redirect, $params = array())
    {
        $methodName = 'get' . $redirect;
        if (method_exists('Redirector', $methodName))
            return Redirector::$methodName($params);
        else {
            $plugins = sfContext::getInstance()->getConfiguration()->getPlugins();
            foreach ($plugins as $plugin) {
                $pluginClass = $plugin . 'Redirector';
                if (class_exists($pluginClass)) {
                    if (method_exists($pluginClass, $methodName))
                        return call_user_func($pluginClass . '::' . $methodName, $params);
                }
            }
        }
    }

    /**
     * @param $oldReferer
     * @param $newReferer
     * @return mixed
     */
    public static function getReferer($oldReferer, $newReferer)
    {
        if (is_null($oldReferer) || $oldReferer == null) {
            return $newReferer;
        } else {
            return $oldReferer;
        }
    }

    /**
     * Funkcja sprawdza czy znajdujemy sie w backendzie.
     * sfConfig::get('sf_app') == 'backend'
     *
     * @return boolean
     */
    public static function isBackend()
    {
        return (sfConfig::get('sf_app') == 'backend');
    }

    /**
     * Funkcja sprawdza czy znajdujemy sie w frontendzie.
     * sfConfig::get('sf_app') == 'frontend'
     *
     * @return boolean
     */
    public static function isFrontend()
    {
        return (sfConfig::get('sf_app') == 'frontend');
    }

}