<?php
/**
 * Description of AddWidgetFormConfiguration
 *
 
 */
class BaseAddWidgetFormConfiguration
{
    protected $forms = array(
        'manufacturer' => array(
            'form' => 'ProductManufacturerForm',
        ),
        'vat' => array(
            'form_name' => 'ProductVatForm',
        ),
        'measure' => array(
            'form' => 'ProductMeasureForm',
        )
    );

    public function getFormName($name)
    {
        $formName = $this->forms[$name]['form'];

        if (class_exists($formName))
            return $formName;
        else
            return 'Plugin' . $formName;
    }

    public function getFieldName($name)
    {
        if (isset($this->forms[$name]['field']))
            $fieldName = $this->forms[$name]['field'];
        else
            $fieldName = 'name';

        return $fieldName;
    }

}