<?php
/**
 * Description of BaseSchemaConfig
 *
 
 */
class BaseSchemaConfig
{
    /**
     *
     * @var string nazwa strony - dla pluginu mailera (tytuły w mailach są z nazwą strony)
     */
    public static $_siteName = 'arteneo.pl';

    /**
     *
     * @var array tablica logowanych modeli doctrinowych (tabel mysqlowych)
     */
    public static $_logTables = array();

    /**
     *
     * @var boolean czy użytkownik system jest w zwykłych, nie pluginowych fixtures
     */
    public static $_isSystemUserInOrdinaryFixtures = false;

    /**
     *
     * @var boolean czy guard ma behaviour softUserDataDelete
     */
    public static $_sfGuardUserSoftDelete = false;

    /**
     *
     * @var boolean czy guard ma być encrypted
     */
    public static $_sfGuardUserEncrypted = false;

    /**
     *
     * @var string nazwa modelu tabeli przechowującej produkty pluginu Payment
     */
    public static $_paymentProductClass = 'ProductBase';

    public static $_sfGuardUserSearchableFields = '';

    public static $_articleSearchableFields = '';
    public static $_articleTranslationSearchableFields = '';

    /**
     *
     * @var array tablica ustawień layoutów do fixtures do galerii do poszczególnych modułów
     */
    public static $_galleryFixtures = array(
        'article' => array(
            'default' => array(
                'gallery_descriptions' => 0,
                'gallery_type' => 'carousel',
                'gallery_caption_position' => 'bottom',
                'gallery_navigation' => 1,
                'gallery_orientation' => 'horizontal',
                'gallery_delay' => 60000,
            ),
            'bez_niczego' => array(
                'gallery_descriptions' => 0,
                'gallery_type' => 'carousel',
                'gallery_caption_position' => 'bottom',
                'gallery_navigation' => 1,
                'gallery_orientation' => 'horizontal',
                'gallery_delay' => 60000,
            ),
        ),
        'product' => array(
            'product_default' => array(
                'gallery_descriptions' => 0,
                'gallery_type' => 'carousel',
                'gallery_caption_position' => 'bottom',
                'gallery_navigation' => 1,
                'gallery_orientation' => 'horizontal',
                'gallery_delay' => 60000,
            )
        )
    );

    public static function getArticleSearchableFields()
    {
        $object = self::getConfigObject();

        return self::$_articleSearchableFields;
    }

    public static function isGuardSoftDeleted()
    {
        $object = self::getConfigObject();

        return self::$_sfGuardUserSoftDelete;
    }

    public static function getArticleTranslationSearchableFields()
    {
        $object = self::getConfigObject();

        return self::$_articleTranslationSearchableFields;
    }

    public static function getGuardSearchableFields()
    {
        $object = self::getConfigObject();

        return self::$_sfGuardUserSearchableFields;
    }

    public static function getGalleryFixtures()
    {
        $object = self::getConfigObject();

        return self::$_galleryFixtures;
    }

    public static function getLogTables()
    {
        $object = self::getConfigObject();

        return self::$_logTables;
    }

    public static function getSiteName()
    {
        $object = self::getConfigObject();

        return self::$_siteName;
    }

    public static function getIsSystemUserInOrdinaryFixtures()
    {
        $object = self::getConfigObject();

        return self::$_isSystemUserInOrdinaryFixtures;
    }

    public static function getGuardUserSoftTemplate()
    {
        $object = self::getConfigObject();

        return self::$_sfGuardUserSoftDelete ? "SoftUserDataDelete: ~" : '';
    }

    public static function getGuardEncryptedTemplate()
    {
        $object = self::getConfigObject();

        return self::$_sfGuardUserEncrypted ? "Encrypted:" : '';
    }

    public static function getGuardEncryptedFields()
    {
        $encrypted = self::getGuardEncryptedTemplate();

        return $encrypted != '' ? "fields: [first_name, last_name, email_address, username]" : '';
    }

    public static function getPaymentProductClass()
    {
        $object = self::getConfigObject();

        return self::$_paymentProductClass;
    }

    /**
     * żeby nadpisać jakieś ustawienia w klasie dziedziczącej, nalezy nadpisać konstruktor (używając również parent::__construct())
     */
    public function __construct()
    {
//    if (!artSettings::checkPluginAvailibilty('artCmsPlugin'))
//      unset(self::$_galleryFixtures['article']);
//    
//    if (!artSettings::checkPluginAvailibilty('artShopPlugin'))
        unset(self::$_galleryFixtures['product']);
//    else
//    {
//      self::$_logTables[] = 'ProductBase';
////      self::$_logTables[] = 'ProductBase';
////      self::$_logTables[] = 'ProductBase';
//    }
    }

    public static function getConfigObject()
    {
        if (class_exists('SchemaConfig'))
            return new SchemaConfig();
        else
            return new BaseSchemaConfig();
    }

}
