<?php
/**
 * Description of FileManagement
 *
 
 */
class FileManagement
{
    //mime_types są wylistowane w klasie sfValidatefFile około linii 240
    protected $model = '';
    public static $actualModel = null;
    public static $_options = array();

    /**
     * Konstruktor.
     *
     * @param null $model
     */
    public function __construct($model = null)
    {
        $this->model = is_null($model) ? self::$actualModel : $model;

        $this->prePrepareOptions();
        $this->prepareOptions();
    }

    final public function prePrepareOptions()
    {
        self::$_options = array(
            'ArticleFile' => array(
                'path' => '/uploads/articles/%id%/files/',
                'foreign_key_name' => 'article_id',
            ),
            'DictionaryFile' => array(
                'path' => '/uploads/dictionary/%id%/files/',
                'foreign_key_name' => 'dictionary_id',
            ),
        );
    }

    /**
     * funkcja służąca do nadpisania ustawień w tablicy $_options w klasie dziedziczącej
     */
    public function prepareOptions()
    {
    }

    /**
     * aby za każdym użyciem funkcji z klasy nie podawać nazwy modelu, należy użyć tej funkcji
     * @param string $model nazwa modelu
     */
    public static function setActualModel($model)
    {
        self::$actualModel = $model;
    }

    public static function getFilePath($fkIdValue, $model, $fileObject = null)
    {
        $path = str_replace('%id%', $fkIdValue, self::getObject($model)->getOption('path'));
        $file = is_null($fileObject) ? '' : $fileObject->getFile();

        return $path . $file;
    }

    public static function getFileAbsolutePath($fkIdValue, $model, $fileObject = null)
    {
        return sfConfig::get('sf_web_dir') . self::getFilePath($fkIdValue, $model, $fileObject);
    }

    public function getOption($option, $default = '')
    {
        if (isset(self::$_options[$this->model]) && isset(self::$_options[$this->model][$option]))
            return self::$_options[$this->model][$option];
        else
            return $default;
    }

    public static function getForeignKeyName($model = null)
    {
        return self::getObject($model)->getOption('foreign_key_name');
    }

    public function getCustomFormClass()
    {
        return $this->getOption('custom_form_class', false);
    }

    public static function getFormClass($model = null)
    {
        $formClass = self::getObject($model)->getCustomFormClass();

        if ($formClass != false)
            return $formClass;
        else
            return class_exists('ProjectFileManagementForm') ? 'ProjectFileManagementForm' : 'FileManagementForm';
    }

    public static function getIconPath($model = null)
    {
        return self::getObject($model)->getOption('icon_path', '/arteneo-theme/images/file_icons/');
    }

    public static function getIconAbsolutePath($model)
    {
        return sfConfig::get('sf_web_dir') . self::getIconPath($model);
    }

    public static function getFileIcon($model, $fileObject)
    {
        return self::getIconPath($model) . $fileObject->getIcon();
    }

    public static function getMaxSize($model = null)
    {
        $maxSize = self::getObject($model)->getOption('file_max_size', false);
        $max = ini_get('upload_max_filesize');

        if ($maxSize)
            $max = min($max, $maxSize);

        if (strpos($max, 'M') !== false)
            $max = ((int)str_replace('M', '', $max)) * 1024 * 1024;

        return $max;
    }

    public static function getMimeTypesWhiteList($model = null)
    {
        return self::getObject($model)->getOption('mime_types_white_list', array());
    }

    public static function getMimeTypesBlackList($model = null)
    {
        return self::getObject($model)->getOption('mime_types_black_list', array());
    }

    /**
     * $file to obiekt pliku (gdy $guessMimeType = false) lub bezwględna ścieżka do pliku (gdy $guessMimeType = true)
     * @return boolean
     */
    public static function hasFileAcceptedMimeType($model, $file, $guessMimeType = false)
    {
        $whiteList = self::getMimeTypesWhiteList($model);
        $blackList = self::getMimeTypesBlackList($model);
        $mimeType = $guessMimeType ? artFile::guessMimeTypeFromFileinfo($file) : $file['type'];

        if (!empty($whiteList))
            return in_array($mimeType, $whiteList);

        if (!empty($blackList))
            return !in_array($mimeType, $blackList);

        return true;
    }

    public static function getObject($model)
    {
        if (class_exists('ProjectFileManagement'))
            return new ProjectFileManagement($model);
        else
            return new FileManagement($model);
    }

    public static function deleteFile($model, $fileObject)
    {
        $fileAbsolutePath = self::getFileAbsolutePath($fileObject->get(self::getForeignKeyName($model)), $model, $fileObject);

        if (file_exists($fileAbsolutePath))
            unlink($fileAbsolutePath);

        $fileObject->delete();
    }
}
