<?php

/**
 * Description of BaseGalleryManagement
 *
 
 */
class GalleryManagement {

  protected $model = '';
  public static $actualModel = null;
  public static $_options = array();

  final public function prePrepareOptions() {
    self::$_options = array(
        'ProductPhoto' => array(
            'path' => '/uploads/products/%id%/',
            'foreign_key_name' => 'product_base_id',
            'small_image' => array(
                'width' => 120,
                'height' => 120,
                'resize_center' => true
            ),
            'medium_image' => array(
                'width' => 500,
                'height' => 500,
                'resize_center' => true
            ),
            'big_image' => array(
                'width' => 800,
                'height' => 800,
                'resize_center' => true
            ),
            'relation_name_from_layout_to_foreign_model' => 'productBases',
        ),
        'ArticlePhoto' => array(
            'path' => '/uploads/articles/%id%/',
            'foreign_key_name' => 'article_id',
            'small_image' => array(
                'width' => 120,
                'height' => 120,
                'resize_center' => true
            ),
            'medium_image' => array(
                'width' => 500,
                'height' => 500,
                'resize_center' => false
            ),
            'big_image' => array(
                'width' => 800,
                'height' => 800,
                'resize_center' => false
            ),
            'relation_name_from_layout_to_foreign_model' => 'Articles',
        ),
        'DictionaryPhoto' => array(
            'path' => '/uploads/dictionary/%id%/',
            'foreign_key_name' => 'dictionary_id',
            'small_image' => array(
                'width' => 120,
                'height' => 120,
                'resize_center' => true
            ),
            'medium_image' => array(
                'width' => 500,
                'height' => 500,
                'resize_center' => false
            ),
            'big_image' => array(
                'width' => 800,
                'height' => 800,
                'resize_center' => false
            ),
        )
    );
  }

  /**
   * funkcja służąca do nadpisania ustawień w tablicy $_options w klasie dziedziczącej
   */
  public function prepareOptions() {
    
  }

  /**
   * aby za każdym użyciem funkcji z klasy nie podawać nazwy modelu, należy użyć tej funkcji
   * @param string $model nazwa modelu
   */
  public static function setActualModel($model) {
    self::$actualModel = $model;
  }

  public function getImagePath($imageSize, $fkIdValue, $photoObject = null) {
    $path = str_replace('%id%', $fkIdValue, $this->getOption('path'));
    $photo = is_null($photoObject) ? '' : $photoObject->__get($imageSize . '_image');

    return $path . $imageSize . '/' . $photo;
  }

  public function getImageAbsolutePath($imageSize, $fkIdValue, $photoObject = null) {
    return sfConfig::get('sf_web_dir') . $this->getImagePath($imageSize, $fkIdValue, $photoObject);
  }

  public function getOption($option, $default = '') {
    if (isset(self::$_options[$this->model]) && isset(self::$_options[$this->model][$option]))
      return self::$_options[$this->model][$option];
    else
      return $default;
  }

  public static function getSmallImagePath($fkIdValue, $model = null, $photoObject = null) {
    return self::getObject($model)->getImagePath('small', $fkIdValue, $photoObject);
  }

  public static function getSmallImageAbsolutePath($fkIdValue, $model = null, $photoObject = null) {
    return self::getObject($model)->getImageAbsolutePath('small', $fkIdValue, $photoObject);
  }

  public static function getMediumImagePath($fkIdValue, $model = null, $photoObject = null) {
    return self::getObject($model)->getImagePath('medium', $fkIdValue, $photoObject);
  }

  public static function getMediumImageAbsolutePath($fkIdValue, $model = null, $photoObject = null) {
    return self::getObject($model)->getImageAbsolutePath('medium', $fkIdValue, $photoObject);
  }

  public static function getBigImagePath($fkIdValue, $model = null, $photoObject = null) {
    return self::getObject($model)->getImagePath('big', $fkIdValue, $photoObject);
  }

  public static function getBigImageAbsolutePath($fkIdValue, $model = null, $photoObject = null) {
    return self::getObject($model)->getImageAbsolutePath('big', $fkIdValue, $photoObject);
  }

  public static function getOriginalImagePath($fkIdValue, $model = null, $photoObject = null) {
    return self::getObject($model)->getImagePath('original', $fkIdValue, $photoObject);
  }

  public static function getOriginalImageAbsolutePath($fkIdValue, $model = null, $photoObject = null) {
    return self::getObject($model)->getImageAbsolutePath('original', $fkIdValue, $photoObject);
  }

  public function getImageOption($imageSize, $optionName, $default = null) {
    $imageArray = $this->getOption($imageSize . '_image', array());

    if (isset($imageArray[$optionName]))
      return $imageArray[$optionName];
    else
      return $default;
  }

  public static function getSmallImageOption($optionName, $default = null, $model = null) {
    return self::getObject($model)->getImageOption('small', $optionName, $default);
  }

  public static function getMediumImageOption($optionName, $default = null, $model = null) {
    return self::getObject($model)->getImageOption('medium', $optionName, $default);
  }

  public static function getBigImageOption($optionName, $default = null, $model = null) {
    return self::getObject($model)->getImageOption('big', $optionName, $default);
  }

  public static function getForeignKeyName($model = null) {
    return self::getObject($model)->getOption('foreign_key_name');
  }

  public function __construct($model = null) {
    $this->model = is_null($model) ? self::$actualModel : $model;

    $this->prePrepareOptions();
    $this->prepareOptions();
  }

  public static function getImageMaxSize($model = null) {
    return self::getObject($model)->getOption('image_max_size', 4 * 1024 * 1024);
  }

  public static function getForeignModel($model) {
    return self::getObject($model)->getOption('relation_name_from_layout_to_foreign_model');
  }

  public static function getObject($model) {
    if (class_exists('ProjectGalleryManagement'))
      return new ProjectGalleryManagement($model);
    else
      return new GalleryManagement($model);
  }

  public static function deletePhoto($model, $photoObject) {
    $gmObject = self::getObject($model);

    foreach (array('small', 'medium', 'big', 'original') as $size) {
      $imageAbsolutePath = $gmObject->getImageAbsolutePath($size, $photoObject->get($gmObject->getOption('foreign_key_name')), $photoObject);

      if (file_exists($imageAbsolutePath))
        unlink($imageAbsolutePath);
    }

    $photoObject->delete();
  }

  /**
   * Zwraca tablice rozmiarow zdjec.
   * 
   * @return array tablica rozmiarow zdjec
   */
  public static function getPhotoSizes($article) {

    #// zmniejsza obrazek tak aby najmniejszy bok mieścił się w docelowym rozmiarze, to co wystaje poza założony rozmiar jest odcinane
    #const IMG_CUT_OUT = 0;
    #// zmniejsza obrazek tak aby największy bok mieścił się w docelowym rozmiarze, obrazek ma rozmiar <= od założonego
    #const IMG_NO_FILL = 1;
    #// zmniejsza obrazek tak aby największy bok mieścił się w docelowym rozmiarze, obrazek jest ustawiany na środku a pozostałe miejsce jest wypełniane kolorem, kolor może być w rgba
    #const IMG_FILL_COLOR = 2;
    #// zmniejsza obrazek tak aby największy bok mieścił się w docelowym rozmiarze, obrazek jest ustawiany na środku na obrazku tła,  rozmiar obrazka będzie taki sam jak rozmiar obrazu tła
    #const IMG_FILL_IMG = 3;

    $sizes = array(
        'small' => array(
            'width' => $article->getParam('img_small_width', 120),
            'height' => $article->getParam('img_small_height', 120),
            'type' => $article->getParam('img_small_type', artPhotoConverter::IMG_CUT_OUT),
            'color' => $article->getParam('img_small_color', 'transparent'),
            'extension' => $article->getParam('img_small_extension', '.png')
        ),
        'medium' => array(
            'width' => $article->getParam('img_medium_width', 500),
            'height' => $article->getParam('img_medium_height', 500),
            'type' => $article->getParam('img_medium_type', artPhotoConverter::IMG_NO_FILL),
            'color' => $article->getParam('img_medium_color', 'transparent'),
            'extension' => $article->getParam('img_medium_extension', '.png')
        ),
        'big' => array(
            'width' => $article->getParam('img_big_width', sfConfig::get('app_art_cms_plugin_article_photo_big_width', 1170)),
            'height' => $article->getParam('img_big_height', sfConfig::get('app_art_cms_plugin_article_photo_big_height', 800)),
            'type' => $article->getParam('img_big_type', sfConfig::get('app_art_cms_plugin_article_photo_big_type', artPhotoConverter::IMG_NO_FILL)),
            'color' => $article->getParam('img_big_color', '#FFFFFF'),
            'extension' => $article->getParam('img_big_extension', '.jpg')
        ),
        'original' => array(
            'width' => $article->getParam('img_original_width', 1920),
            'height' => $article->getParam('img_original_height', 1080),            
            'type' => $article->getParam('img_original_type', artPhotoConverter::IMG_NO_FILL),
            'extension' => $article->getParam('img_original_extension', '.jpg')
        )
    );

    return $sizes;
  }

}
