<?php
/**
 * Description of PluginDictionaryTabFormConfiguration
 *
 */
class PluginPaDictionaryTabFormConfiguration extends BaseTabFormConfiguration
{
    protected $configuration = array(
        'DictionaryTab' => array(
            'form_class' => 'DictionaryForm',
            'foreign_key_name' => 'id',
            'doctrine_object_class' => 'Dictionary',
        ),
        'SetPolishWordOrderTab' => array(
            'required_foreign_keys' => array('id')
        ),
        'SetEnglishWordOrderTab' => array(
            'required_foreign_keys' => array('id')
        ),
        'FilesTab' => array(
            'required_foreign_keys' => array('id'),
            'multipart_form' => true,
        ),
        'GalleryTab' => array(
            'required_foreign_keys' => array('id'),
            'multipart_form' => true,
        ),
    );

    public function __construct(artTabActions $actionsObject)
    {
        if (!sfConfig::get('app_dictionary_with_files_tab', false))
            unset($this->configuration['FilesTab']);

        if (!sfConfig::get('app_dictionary_with_gallery_tab', false))
            unset($this->configuration['GalleryTab']);

        parent::__construct($actionsObject);
    }
}

