<?php
/**
 * Description of artSettings
 *
 
 */
class artSettings
{
    /**
     * @param $parameters
     */
    public static function setTemplatesVars(&$parameters)
    {
        $context = sfContext::getInstance();

        $parameters['_culture'] = $context->getUser()->getCulture();
        $parameters['_wrapperClass'] = 'wrapper-' . $context->getModuleName() . '-' . $context->getActionName() . ' wrapper-' . $context->getModuleName() . ' wrapper-' . $parameters['_culture'];
    }

    /**
     * @param $pluginName
     * @return bool
     */
    public static function checkPluginAvailibilty($pluginName)
    {
        try {
            $context = sfContext::getInstance();
        } catch (sfException $e) {
            $configuration = ProjectConfiguration::getApplicationConfiguration('frontend', 'dev', true);
            $context = sfContext::createInstance($configuration);
        }

        $plugins = $context->getConfiguration()->getPlugins();

        //np  sfArtMailerPlugin
        return in_array($pluginName, $plugins);
    }

    /**
     * @return bool
     */
    public static function isDevEnvironment()
    {
        return sfConfig::get('sf_environment') == 'dev';
    }

    /**
     * @return bool
     */
    public static function isBackendApp()
    {
        return sfConfig::get('sf_app') == 'backend';
    }

    /**
     * @param $text
     * @param null $objectWhereCalled
     * @param bool $withIP
     */
    public static function insertInApplicationLog($text, $objectWhereCalled = null, $withIP = true)
    {
        if ($withIP)
            $text .= ' z IP ' . $_SERVER['REMOTE_ADDR'];

        sfContext::getInstance()->getEventDispatcher()->notify(new sfEvent($objectWhereCalled, 'application.log', array($text)));
    }

    /**
     * @return mixed
     */
    public static function getUploadsTmpDir()
    {
        return sfConfig::get('app_uploads_tmp_dir', sfConfig::get('sf_upload_dir') . '/tmp');
    }

    /**
     * @param $projectClass
     * @param $pluginClass
     * @param $returnOnlyClassName
     * @return mixed
     */
    public static function getObject($projectClass, $pluginClass, $returnOnlyClassName)
    {
        $className = class_exists($projectClass) ? $projectClass : $pluginClass;

        if ($returnOnlyClassName)
            return $className;
        else
            return new $className();
    }

    /**
     * @param $className
     * @param string $pluginPrefix
     * @param string $projectPrefix
     * @param bool $returnOnlyClassName
     * @return mixed
     */
    public static function getConfigurationObject($className, $pluginPrefix = '', $projectPrefix = '', $returnOnlyClassName = false)
    {
        $projectClass = $projectPrefix . $className;
        $pluginClass = $pluginPrefix . $className;

        return self::getObject($projectClass, $pluginClass, $returnOnlyClassName);
    }

}
