<?php
class artTable
{
    public static $opntr = "<tr";
    public static $endtr = '</tr>';
    public static $opntd = '<td';
    public static $endtd = '</td>';
    public static $rowspan = 'rowspan=';

    /**
     * Return text, converting @var $html, which including html tags : '<table>'
     * WORK ONLY FOR 2 COLUMNS
     *  and converting it into string
     * @param String $html
     * @return String
     */
    public static function StripTable($html)
    {
        $table = array();
        $ok = true;
        $offset = 0;
        $endtr_pos = 0;
        $opntr_pos = 0;
        $rowspan = 0;
        $i_ok = 0;
        $i = 0;
        while ($ok === true) {
            if (($opntr_pos = stripos($html, self::$opntr, $offset)) && ($endtr_pos = stripos($html, self::$endtr, $offset)) !== false) {
                $rowspan_nr = 0;
                $len = $endtr_pos - $opntr_pos;
                $row = substr($html, $opntr_pos, $len);
                $tab = explode(self::$endtd, $row);
                $i_ok = 0;
                $i = 0;

                $n = count($table);

                foreach ($tab as $tt) {
                    $opentd_pos = strpos($tt, self::$opntd);
                    $opntd_end = stripos($tt, chr(62), $opentd_pos);
                    $rowspan_pos = stripos($tt, self::$rowspan, $opentd_pos);
                    if ($rowspan_pos < $opntd_end && $rowspan_pos !== false && $opentd_pos !== false) {
                        $len = $rowspan_pos + strlen(self::$rowspan) + 1;
                        if ($i == 0) $rowspan_nr = intval(substr($tt, $len, 1));
                        if ($i == 1) $rowspan_nr = 0;
                    }
                    $i++;
                }
                unset($tab[count($tab) - 1]);
                $table[$n] = array();
                if ($rowspan > 1) {
                    array_unshift($table[$n], null);
                    $rowspan_nr = $rowspan - 1;
                }
                foreach ($tab as $t)
                    array_push($table[$n], $t);

                $rowspan = $rowspan_nr;
                $rowspan_nr = 1;


            } else
                $ok = false;
            $offset = $endtr_pos + 1;
        }

        $b = artMatrix::getTransponse($table);

        return self::getTableToString($b);
//	return $b;
    }

    /**
     * Get table into string
     * @param array $table
     * @return String;
     */
    public static function getTableToString(array $tab)
    {
        $str = NULL;
        foreach ($tab as $ftab)
            foreach ($ftab as $fwtab)
                $str .= $fwtab;

        return $str;
    }
}

?>