<?php
include_once 'Stack.php';

class TextMixer
{
    private $stack;
    private $textToParse;
    private $text;

    /**
     *
     * @param type $string String do zmixowania
     */
    public static function getInstance($string)
    {
        $textMixer = new TextMixer($string);
        return $textMixer;
    }

    private function scal()
    {
        $b = "";
        for ($j = 0; $j < $this->stack->size(); $j++) {
            if ($this->stack->stack[$j] != '') {
                $b = $b . $this->stack->stack[$j];
            }
        }
        return $b;
    }

    private function prepareString()
    {
        $preparingText = preg_replace('![ ]*[\{][ ]*!', ' { ', $this->text);
        $preparingText = preg_replace('![ ]*[\}][ ]*!', ' } ', $preparingText);
        $preparingText = preg_replace('![ ]*[\|][ ]*!', ' | ', $preparingText);
        return $preparingText;
    }

    private function validate($text)
    {
        return preg_replace('!\s+!', ' ', $text);
    }

    public function isValid($text)
    {
        $left = substr_count($text, '{');
        $right = substr_count($text, '}');
        if ($left == $right) {
            return true;
        } else {
            return false;
        }
    }

    public function isValidExit($text)
    {
        $error = substr_count($text, '{');
        $error = +substr_count($text, '}');
        return $error;
    }

    public function generateRandomPost()
    {
        if ($this->isValid($this->text)) {
            $b = '';
            for ($i = 0; $i < strlen($this->text); $i++) {
                if ($this->text[$i] == '}') {
                    $tempa = '';
                    $tempb = '';
                    $tempc = '';
                    $c = '';
                    while ($tempa != '{') {
                        $tempa = $this->stack->pop();
                        if ($tempa != '{') {
                            $c = $tempa . $c;
                        }
                    }
                    $tempb = explode("|", $c);
                    $tempc = $tempb[rand(0, count($tempb) - 1)];
                    $this->stack->push($tempc);
                } else {
                    $this->stack->push($this->text[$i]);
                }
            }
            $c = '';

            return $this->validate($this->scal());
        }
    }

    public function getRandomPost()
    {
        $error = 0;
        if ($this->isValidExit($this->generateRandomPost()))
            if ($error > 10)
                return '';
            else
                $error++;
        else
            return $this->validate($this->scal());

    }

    public function showText()
    {
        echo $this->textToParse;
    }


    public function __construct($textToParse)
    {
        $this->text = $textToParse;
        $this->text = $this->prepareString();
        $this->textToParse = $textToParse;
        $this->stack = new Stack();
    }
}

?>
