<?php

class artString
{

    /**
     * Search last 'needle'  to the 'offset' in 'haystack'
     * EXCEPTION: use strripos except this function
     * @param String $haystack
     * @param String $needle
     * @param Integer $offset
     * @return Integer
     */
    public static function strrevpos($haystack = "", $needle = "", $offset = 0)
    {
        $length = strlen($haystack);
        $position = stripos(strrev($haystack), strrev($needle), $length - $offset - 1);
        if ($position === false)
            return false;
        else
            return ($length - strlen($needle) - $position);
    }

    /**
     * Function remove html $tags get in the second parameter of the function
     * @param String $haystack
     * @param String $tags
     * @return String
     */
    public static function striprev_tags($haystack, $tags)
    {
        if (!is_array($tags)) {
            $tags = (strpos($haystack, '>') !== false ? explode('>', str_replace('<', '', $tags)) : array($tags));
            if (end($tags) == '')
                array_pop($tags);
        }
        foreach ($tags as $tag)
            $haystack = preg_replace('#</?' . $tag . '[^>]*>#is', '', $haystack);
        return $haystack;
    }

    /**
     * Function find first '&#60;' (in array it is in return_array['begin'])in back starting searching from the <b>offset</b>,
     * then get the name of the tag under return_array ['tag_name']. Next it finds end of the tags return_array['end'].
     * <b>$heystack</b> is searching string.<br/>
     * Function can be use for searching all tags by the specify class name or id in the documents by php.
     *
     *
     * @example WARNING!!!!$haystack params in html tag must be distract. ex.: &#60;div class='name_class' id='name_id'&#62;
     * not &#60;divclass='name_class'id='id_name'&#62;
     *
     * @param String $haystack
     * @param Int $offset
     * @return array('begin','tag_name','end')
     */
    public static function str_tagspos($haystack = "", $offset = 0)
    {
        //searching backward position '<'
        $begin = self::strrevpos($haystack, chr(60), $offset);
        //searching forward  position '>'
        $end = stripos($haystack, chr(62), $offset);
        if ($begin === FALSE)
            return false;
        $tag_name = self::getTagName($haystack, $begin);
        if ($end === FALSE)
            return false;

        return array(
            'begin' => $begin,
            'tag_name' => $tag_name,
            'end' => $end
        );
    }

    /**
     * Return the first for given in the string from the offset.
     *
     * @example echo artString::getTagName('<div><b>some</b></div>'); return the name of the 'div'
     * @param String $haystack
     * @param int $offset
     * @return Strinf
     */
    public static function getTagName($haystack = "", $offset = 0)
    {
        $j = $offset + 1;
        $ok = true;
        $posAsc255 = stripos($haystack, " ", $offset);
        return substr($haystack, $offset + 1, -(strlen($haystack) - $posAsc255));
    }

    /**
     * Return array of end tag position
     * @param String $haystack
     * @param Array $tagpos
     *
     * @name $tagpos array('begin','end')
     */
    public static function str_tagendpos($haystack, $tagpos)
    {
        //is  <tag_name
        $niddleTagOpen = chr(60) . $tagpos['tag_name'];
        //is: </tag_name>
        $niddleTagClose = self::getEndTag($tagpos['tag_name']);
        //get first close tag after end param of the searching tag
        $firstClose = stripos($haystack, $niddleTagClose, $tagpos['end']);
        //get the first open tag after end param of searching tag
        $firstOpen = stripos($haystack, $niddleTagOpen, $tagpos['end']);

        /** @todo tutuj dopisac sprawdzanie tagow zamykajacych
         */
        return array(
            'begin' => $firstClose,
            'end' => $firstClose + strlen($tagpos['tag_name']) + 2);
    }

    /**
     * Return word starting from the offset based on the word length
     * @param string $haystack
     * @param string $word
     * @param int $offset
     * @return string
     */
    public static function strFromOffset($haystack = '', $word = '', $offset = 0)
    {
        $length = strlen($word);
        return substr($haystack, $offset, -(strlen($haystack) - $offset + $length));
    }

    /**
     * Return end of the html tag
     * @param String $h
     * @return &#60;/$h&#62;
     */
    public static function getEndTag($h)
    {
        return chr(60) . chr(47) . $h . chr(62);
    }

    /**
     * Return start of the html tag
     * @param String $h
     * @return &#60;$h&#62;
     */
    public static function getBeginTag($h)
    {
        return chr(60) . $h . chr(62);
    }

    /**
     * Function remove white spaces in html file before  char '<'
     * @param String $str
     * @return String
     */
    public static function removeWhiteSpace($str)
    {
        return preg_replace('/\s+</', '<', trim($str));
    }

    /**
     * Function returns true if the string in $haystack ends with the string in $needle
     * @param String $needle
     * @param String $haystack
     * @return bool
     */
    public static function endsWith($needle, $haystack)
    {
        return preg_match("/" . preg_quote($needle) . '$/', $haystack);
    }

    /**
     * Function returns true if the string in $haystack starts with the string in $needle
     * @param String $needle
     * @param String $haystack
     * @return bool
     */
    public static function startsWith($needle, $haystack)
    {
        return preg_match('/^' . preg_quote($needle) . "/", $haystack);
    }

    public static function trim_to_given_char($string, $char)
    {
        return substr($string, 0, strpos($string, $char));
    }

    public static function bool_to_string($var)
    {
        if (is_bool($var))
            return $var ? "true" : "false";
        else
            return $var;
    }
}
