<?php

/**
 * Description of artStringConverterclass
 *
 */
class artStringConverter
{

    /**
     * Change '_' -> ' '
     * @param String $haystack
     * @return
     */
    public static function sluggable($haystack)
    {
        return str_replace('_', ' ', $haystack);
    }

    public static function change42And58ASCII($value)
    {
        $pattern = array();
        $pattern[0] = '/\:/';
        $pattern[1] = '/\*/';
        $pattern[2] = '/\|/';
        $replace = array();
        $replace[0] = '&#58;';
        $replace[1] = '&#42;';
        $replace[2] = '&#124;';
        return preg_replace($pattern, $replace, $value);
    }

    public static function replaceUTFtoASCII($value)
    {
        $polishChars = array('ą', 'ę', 'ó', 'ś', 'ć', 'ż', 'ź', 'ń', 'ł', 'Ą', 'Ę', 'Ó', 'Ś', 'Ć', 'Ż', 'Ź', 'Ń', 'Ł', '\/\/u201d\/\/', '\/\/u201e\/\/'); //'”', '„');
        $utfChars = array('\u0105', '\u0119', '\u00F3', '\u015B', '\u0107', '\u017C', '\u017A', '\u0144', '\u0142', '\u0104', '\u0118', '\u00D3', '\u015A', '\u0106', '\u017B', '\u0179', '\u0143', '\u0141', 'u201D', 'u201E');
        $utfSmallChars = array('\u0105', '\u0119', '\u00f3', '\u015b', '\u0107', '\u017c', '\u017a', '\u0144', '\u0142', '\u0104', '\u0118', '\u00d3', '\u015a', '\u0106', '\u017b', '\u0179', '\u0143', '\u0141', 'u201d', 'u201e');

        $value = str_replace($utfChars, $polishChars, $value);
        return str_replace($utfSmallChars, $polishChars, $value);
    }

    public static function jsonEncodeWithPolishChars($value)
    {
        $value = json_encode($value);

        return self::replaceUTFtoASCII($value);
    }

    public static function clipTextToRectangle($text, $rowsNumber, $charsToNewLine)
    {
        if ($rowsNumber > 0) { //jezeli długość wierszy jest ograniczona dla konkretnego tekstu
            $returnTab = array();
            $tabPerNewLine = explode("\n", $text);

            if (count($tabPerNewLine) > 1)
                foreach ($tabPerNewLine as $i => $value)
                    $tabPerNewLine[$i] = trim($value);

            foreach ($tabPerNewLine as $i => $value) { //pętla po wszystkich liniach danego tekstu
                $lengthOfString = strlen(strip_tags(html_entity_decode($value))); //długość stringa bez znaczników htmlowych

                if ($lengthOfString > $charsToNewLine) { //jeżeli długość danej linii jest dłuższa niż dozwolona ilosc znakow w linii to...
                    $tabPerSpace = explode(' ', $value); //podzielenie pojedynczej linii na słowa
                    $string = '';

                    $countTabPerSpace = count($tabPerSpace);

                    foreach ($tabPerSpace as $j => $word) { //pętla po wszystkich słowach danej linii
                        $lengthOfString = strlen(strip_tags(html_entity_decode($string . $word))); //długość stringa bez znaczników htmlowych

                        if ($lengthOfString <= $charsToNewLine && strlen($word) > 0) //sprawdzanie czy dodanie słowa nie spowoduje przeskoczenia do następnej linii
                            $string .= $word . ' ';
                        else { //jeżeli spowoduje przeskoczenie to...
                            $stringToPut = trim($string);

                            //sprawdzanie długości stringa do wstawienia
                            if (strlen($stringToPut) > 0) {
                                $returnTab[] = $stringToPut;
                                $string = $word . ' ';
                            } else { //jezeli długość stringa jest 0, to oznacza, ze cale slowo jest dluzsze niz $this->charsToNewLine, czyli to słowo trzeba łamać na wiersze
                                //dopóki słowo potrzebuje dzielenia, to jest dzielone i dodawane '-' na końcu
                                do {
                                    $stringToPut = trim(substr($word, 0, $charsToNewLine - 3));
                                    $returnTab[] = $stringToPut . '-';
                                    $word = substr($word, $charsToNewLine - 3);
                                } while (strlen($word) > ($charsToNewLine - 3));

                                $string = $word . ' ';
                            }
                        }
                    }

                    //dziwny warunek, ale bez niego zle dodaje ostatni wiersz
                    if ($string != '' && $string != ($returnTab[count($returnTab) - 1] . ' '))
                        $returnTab[] = trim($string);
                } else if (strlen($value) > 0)
                    $returnTab[] = $value;
            }

            //jezeli ilosc elementow w wynikowej tablicy jest wieksza niz dozwolona ilosc wierszy, to trzeba zwracac tylko czesc tekstu
            if (count($returnTab) > $rowsNumber) {
                $returnTabAfterChunk = array_chunk($returnTab, $rowsNumber);
                $text = implode('<br />', $returnTabAfterChunk[0]);
                $lastIndexOfString = strlen($text) - 1;

                if ($text[$lastIndexOfString] == '-')
                    $text = substr($text, 0, -1);

                $text .= '(...)';
            } else
                $text = implode('<br />', $returnTab);
        }

        return $text;
    }

    public static function addDotes($string, $length)
    {
        return strlen($string) > $length ? mb_substr($string, 0, $length, 'UTF-8') . '(...)' : $string;
    }

    public static function addOnly3Dotes($string, $length)
    {
        return strlen($string) > $length ? mb_substr($string, 0, $length, 'UTF-8') . '...' : $string;
    }

    public static function addOnly1Dot($string, $length)
    {
        return strlen($string) > $length ? mb_substr($string, 0, $length, 'UTF-8') . '.' : $string;
    }

    public static function noPolishChars($text)
    {
        $table = array(
            //WIN
            "xb9" => "a", "xa5" => "A", "xe6" => "c", "xc6" => "C",
            "xea" => "e", "xca" => "E", "xb3" => "l", "xa3" => "L",
            "xf3" => "o", "xd3" => "O", "x9c" => "s", "x8c" => "S",
            "x9f" => "z", "xaf" => "Z", "xbf" => "z", "xac" => "Z",
            "xf1" => "n", "xd1" => "N",
            //UTF
            "xc4x85" => "a", "xc4x84" => "A", "xc4x87" => "c", "xc4x86" => "C",
            "xc4x99" => "e", "xc4x98" => "E", "xc5x82" => "l", "xc5x81" => "L",
            "xc3xb3" => "o", "xc3x93" => "O", "xc5x9b" => "s", "xc5x9a" => "S",
            "xc5xbc" => "z", "xc5xbb" => "Z", "xc5xba" => "z", "xc5xb9" => "Z",
            "xc5x84" => "n", "xc5x83" => "N",
            //polskie znaki - dodane przez MM
            "ą" => "a", "Ą" => "A", "ć" => "c", "Ć" => "C",
            "ę" => "e", "Ę" => "E", "ł" => "l", "Ł" => "L",
            "ó" => "o", "Ó" => "O", "ś" => "s", "Ś" => "S",
            "ż" => "z", "Ż" => "Z", "ź" => "z", "Ź" => "Z",
            "ń" => "n", "Ń" => "N",
            //ISO
            "xb1" => "a", "xa1" => "A", "xe6" => "c", "xc6" => "C",
            "xea" => "e", "xca" => "E", "xb3" => "l", "xa3" => "L",
            "xf3" => "o", "xd3" => "O", "xb6" => "s", "xa6" => "S",
            "xbc" => "z", "xac" => "Z", "xbf" => "z", "xaf" => "Z",
            "xf1" => "n", "xd1" => "N");

        return strtr($text, $table);
    }

}