<?php

/**
 * Description of artWidgetShowText
 *
 */
class artWidgetFormShowText extends sfWidgetForm {

  /**
   * Constructor.
   *
   * Available options:
   *
   *  * id_format:       The format for the generated HTML id attributes (%s by default)
   *  * is_hidden:       true if the form widget must be hidden, false otherwise (false by default)
   *  * needs_multipart: true if the form widget needs a multipart form, false otherwise (false by default)
   *  * default:         The default value to use when rendering the widget
   *  * label:           The label to use when the widget is rendered by a widget schema
   *
   * @param array $options     An array of options
   * @param array $attributes  An array of default HTML attributes
   *
   * @see sfWidget
   */
  public function __construct($text, $options = array(), $attributes = array()) {
    $this->addOption('text', $text);
    $this->addOption('id_format', '%s');
    $this->addOption('is_hidden', false);
    $this->addOption('needs_multipart', false);
    $this->addOption('default', null);
    $this->addOption('label', false);

    parent::__construct($options, $attributes);
    $this->setLabel(false);
  }
  
  /**
   * Sets the text for the widget.
   *
   * @param string $value The text
   *
   * @return sfWidget The current widget instance
   */
  public function setText($value)
  {
    $this->setOption('text', $value);

    return $this;
  }

  /**
   * Returns the text for the widget.
   *
   * @return string The text
   */
  public function getText()
  {
    return $this->getOption('text');
  }

  public function render($name, $value = null, $attributes = array(), $errors = array()) {
    return '<div class="col-md-12 alert alert-info">'.$this->getOption('text').'</div>';
  }

}
