<?php

/**
 * Frontend Management actions
 *
 * @subpackage frontend_management

 */
class PluginArtConfigurationActions extends artActions {

  /**
   * Funkcja sprawdza czy request jest wywolany przez AJAX
   * @param sfWebRequest $request 
   */
  public function preExecute() {
    if (!$this->getRequest()->isXmlHttpRequest()) {
      $this->redirect(Redirector::get('NotXmlHttp'));
    }
  }
 
  /** ArtConfiguration **/

  /**
   * Akcja AJAX dodawania kategorii. Przekazywanie wartosci do formularza przez
   * options w routing lub request.
   * routing.yml: art_configuration_edit
   * Potrzebne prawa: [admin, art_configuration]
   * (Poza security.yml poniewaz chcemy inaczej obsluzyc brak praw)
   * 
   * @param sfWebRequest $request
   */
  public function executeArtConfigurationEdit(sfWebRequest $request) {
    if (!$this->checkPermissions(array('admin', 'art_configuration'))) {
      return $this->renderText(Redirector::get('AjaxNoPermission', array('user' => $this->getUser())));
    }

    if (!$request->hasParameter('id')) {
      throw new InvalidArgumentException('Brak wymaganego parametru: "id"');
    }

    $acObject = Doctrine::getTable('ArtConfiguration')->findOneById($request->getParameter('id'));

    if (!$acObject || $acObject->getEditable() != 1) {
      return $this->renderText(Redirector::get('ArtConfigurationNotExist', array('user' => $this->getUser())));
    }
    $this->form = new ArtConfigurationForm($acObject);

    if ($this->form->bindFromRequestAndSave($request)) {
      $this->clearCache();
      return $this->renderText(Redirector::get('ArtConfigurationEditSuccess', array('user' => $this->getUser())));
    }
    // Ustaw parametry dla url w formularzu (aby przekazac opcje np. category_id)
    $this->formUrlParameters = $this->getFormUrlParameters($request);
    
    $this->page = 1;
    if ($request->hasParameter('page')) {
      $this->page = $request->getParameter('page');
    }
  }

  /**
   * Akcja AJAX edycji kategorii.
   * routing.yml: art_configuration_list
   * Potrzebne prawa: [admin, art_configuration]
   * (Poza security.yml poniewaz chcemy inaczej obsluzyc brak praw)
   * 
   * @param sfWebRequest $request
   */
  public function executeArtConfigurationList(sfWebRequest $request) {
    if (!$this->checkPermissions(array('admin', 'art_configuration'))) {
      return $this->renderText(Redirector::get('AjaxNoPermission', array('user' => $this->getUser())));
    }
    
    $this->pager = new sfDoctrinePager('ArtConfiguration', sfConfig::get('app_artconfiguration_paginator_limit', 6));
    
    $this->pager->setQuery(Doctrine::getTable('ArtConfiguration')->getOrderedArtConfiguration('ASC'));
    $this->pager->setPage($request->getParameter('page', 1));
    $this->pager->init();
  }
  
  /** KONIEC - ArtConfiguration **/
  

  /**
   * Funkcja zwraca string parametrow dla url formularza
   * W parametrach uwzglednia:
   * - 'id'
   * 
   * @param array $formOptions
   * @return string
   */
  public function getFormUrlParameters($request) {
    $parameters = array();

    if ($request->hasParameter('id')) {
      $parameters[] = 'id=' . $request->getParameter('id');
    }

    return (!empty($parameters) ? '?' . implode('&', $parameters) : '');
  }

  /**
   * Funkcja przeznaczona do zmiany, jesli chcemy ograniczyc zakres czyszczenia
   * cache po zmianie artykulow. Wywoluje sie po dodaniu, edycji, usunieciu
   * artykulow, referencji, kategorii.
   */
  public function clearCache() {
    artTask::clearCache();
  }

  /**
   * Funkcja sprawdza czy user ma prawa podane w tablicy $parmissions
   * @param array $permissions
   * @return boolean 
   */
  protected function checkPermissions($permissions) {
    return $this->getUser()->hasPermission($permissions, false);
  }

}
