<?php

/**
 * Default actions
 *
 * @subpackage default

 */
class PluginDefaultActions extends artActions {
  
  /**
   * Przekierowanie na strone glowna.
   */
  public function executeHomepage()
  {
    // Pobranie URL
    $url = Menu::getHomepageUrl(sfConfig::get('app_homepage_menu_file', 'topMenu.yml'), sfConfig::get('app_homepage_position', 1));
    
    // Pobranie Routes i ustawienie parametrow
    $routes = $this->getContext()->getRouting()->getRoutes();
    if (! (strpos($url, '?') === false)) {
      $rule = substr($url, 0, strpos($url, '?'));
      $paramsString = substr($url, strpos($url, '?') + 1);
      $params = explode('&', $paramsString);
      foreach ($params as $param) {
        $tmp = explode('=', $param);
        $this->getRequest()->setParameter($tmp[0], $tmp[1]);
      }
    } else {
      $rule = $url;
    }

    // Pobranie Module i Action oraz forward
    $defaults = $routes[$rule]->getDefaults();
    $this->forward($defaults['module'], $defaults['action']);
  }
}
