<?php

/**
 * File actions
 * @subpackage file

 */
 
class PluginfileActions extends artActions
{

  public function preExecute()
  {
    $request = $this->getRequest();
    $this->model = $request->getParameter('model');
    $this->fkIdValue = $request->getParameter('id');
  }

  public function executeIndex(sfWebRequest $request)
  {
    if (method_exists($this->model . 'Table', 'getBackendFilesList'))
      $this->files = Doctrine::getTable($this->model)->getBackendFilesList($this->fkIdValue);
    else
    {
      $userCulture = $this->getUser()->getCulture();
      $foreignKeyName = FileManagement::getForeignKeyName($this->model);

      $this->files = Doctrine_Query::create()
              ->from($this->model . ' f')
              ->leftJoinTranslation('f')
              ->where('f.' . $foreignKeyName . ' = ?', $this->fkIdValue)
              ->orderBy('f.order ASC, f.id ASC')
              ->execute();
    }

    $this->newOrder = $this->files->count() + 1;

    $this->form = $this->prepareNewFileForm($this->newOrder);
  }

  public function executeSaveOrder(sfWebRequest $request)
  {
    if ($request->isMethod('POST'))
    {
      $files = $request->getParameter('setOrder');
      $order = 1;

      foreach ($files as $fileId)
      {
        if (method_exists($this->model . 'Table', 'updateOrder'))
          Doctrine::getTable($this->model)->updateOrder($fileId, $order);
        else
          Doctrine_Query::create()
                  ->from($this->model)
                  ->update()
                  ->set('order', $order)
                  ->where('id = ?', $fileId)
                  ->execute();

        $order++;
      }

      $this->getUser()->setFlash('notice', 'Dane zostały zapisane pomyślnie.');
    }

    $this->forward('file', 'index');
  }

  public function executeDeleteFile(sfWebRequest $request)
  {
    $fileId = $request->getParameter('fileId');
    $fileObject = Doctrine::getTable($this->model)->find($fileId);
    FileManagement::deleteFile($this->model, $fileObject);
    
    $this->getUser()->setFlash('notice', 'Zdjęcie zostało usunięte!');

    $this->forward('file', 'index');
  }

  public function executeNewFile(sfWebRequest $request)
  {
    $newOrder = $request->getParameter('new_order');
    $form = $this->prepareNewFileForm($newOrder);
    
    if ($request->isMethod('post') && $request->hasParameter($form->getName()))
    {
      $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));

      if ($form->isValid())
      {
        $form->save();
        
        return sfView::NONE;
      }
    }
    
    //do zmiany jak będzie czas :D
    return $this->renderPartial('file/file_form_with_errors', array('form' => $form));
  }

  public function executeDownloadFile(sfWebRequest $request)
  {
    $model = $request->getParameter('model');
    $fileId = $request->getParameter('fileId');
    $fkIdValue = $request->getParameter('id');
    
    $fileObject = Doctrine::getTable($model)->find($fileId);
    
    $file = FileManagement::getFileAbsolutePath($fkIdValue, $model, $fileObject);
    
    $response = $this->getResponse();
    $response->clearHttpHeaders();
    $response->addCacheControlHttpHeader('Cache-control', 'must-revalidate, post-check=0, pre-check=0');
    $response->setContentType(artFile::guessMimeTypeFromFileinfo($file), TRUE);
    $response->setHttpHeader('Content-Transfer-Encoding', 'binary', TRUE);
    $response->setHttpHeader('Content-Disposition', 'attachment; filename="' .$fileObject->getOriginalFilename() . '"', TRUE);
//    zakomentowane, bo dla niektórych plików powoduje błąd, którego nie da się złapać try - catchem
//    $response->setHttpHeader('Content-Length', filesize($file), true); 
    $response->sendHttpHeaders();

    @readfile($file);
    
    return sfView::NONE;
  }
  
  protected function prepareNewFileForm($newOrder)
  {
    $fileObject = new $this->model();
    $fileObject->setOrder($newOrder);
    $fileObject->__set(FileManagement::getForeignKeyName($this->model), $this->fkIdValue);

    $formClass = FileManagement::getFormClass($this->model);

    return new $formClass($fileObject, array('model' => $this->model, 'fkIdValue' => $this->fkIdValue));
  }

}
