<?php

/*
 * This file is part of the symfony package.
 * (c) 2004-2006 Fabien Potencier <fabien.potencier@symfony-project.com>
 * 
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * defaultActions module.
 *
 * @package    symfony
 * @subpackage action
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class Pluginlibrary_actionsActions extends artActions
{

  public function executeGetPlusWidgetPopupForm(sfWebRequest $request)
  {
    if ($request->isXmlHttpRequest())
    {
      if (class_exists('AddWidgetFormConfiguration'))
        $configuration = new AddWidgetFormConfiguration();
      else
        $configuration = new BaseAddWidgetFormConfiguration();

      $this->formToUse = $request->getParameter('form_to_use');
      $this->selectCaller = $request->getParameter('selectCaller', '');
      $this->inputCaller = $request->getParameter('inputCaller', '');

      $chosenForm = $configuration->getFormName($this->formToUse);
      $fieldToGet = $configuration->getFieldName($this->formToUse);
      $this->setLayout('empty_layout');
      $this->form = new $chosenForm();

      if ($request->hasParameter($this->form->getName())) //mamy wypelniony formularz
      {
        $this->form->bind($request->getParameter($this->form->getName()));

        if ($this->form->isValid()) //waliduje sie poprawnie
        {
          $formObject = $this->form->save(); //zapisz form
          $data = $formObject->getId() . "|" . $formObject->__get($fieldToGet) . "|closepopup"; //"foo:*:1023:1000::/home/foo:/bin/sh";

          return $this->renderText($data);
        }else
        {
//        $data = $this->form->getId() . "|" . $this->form->__get($fieldToGet) . "|"; //"foo:*:1023:1000::/home/foo:/bin/sh";

  //        return $this->renderText($data);
        }
      }
    }
  }

  public function executeAjaxFileUpload(sfWebRequest $request)
  {
    sfConfig::set('sf_web_debug', false);
    $this->setLayout('empty_layout');
    $file = $request->getFiles();
    $inputFileId = $request->getParameter('input_file_id');

    while (is_array(current($file)))
      $file = current($file);
    
    $configuration = artSettings::getConfigurationObject('AjaxFileUploadConfiguration', 'Base');
    $mimeTypes = $configuration->getMimeTypes($inputFileId);
    
    //jeżeli tablica pliku jest pusta, wystąpił błąd uploadu lub typ pliku jest niezgodny z dopuszczalnymi typami, zwróć jsona, bez operacji na plikach
    if (empty($file) || $file['error'] || (!empty($mimeTypes) && !in_array($file['type'], $mimeTypes)))
      return $this->renderJson($file);

    $tmpDir = artSettings::getUploadsTmpDir();
    $extension = substr($file['name'], strrpos($file['name'], '.'));
    $hashImgName = md5($file['name'] . time() . sfContext::getInstance()->getUser()->getId()) . $extension;
    
    if (!is_dir($tmpDir))
      mkdir($tmpDir, 0777, true);
    
    artFile::moveFile($file['tmp_name'], $tmpDir . '/' . $hashImgName, true);
    
    $file['tmp_name'] = $hashImgName;
    
    return $this->renderJson($file);
  }

}