<script type="text/javascript">
  /* <![CDATA[ */
  $(document).ready(function() {
    $('[name="batch_action"]').change(function(){
      batchSelectUpdate($(this).val());
    });
  });

  function batchSelectUpdate(valToPut){
    $('[name="batch_action"]').each(function(){
      $(this).val(valToPut);
    })
    $('[name="batch_action"]').multiselect("refresh");
  }

  function checkAll()
  {
    var boxes = document.getElementsByTagName('input'); for(var index = 0; index < boxes.length; index++) { box = boxes[index]; if (box.type == 'checkbox' && box.className == 'sf_admin_batch_checkbox') box.checked = document.getElementById('sf_admin_list_batch_checkbox').checked } return true;
  }
  /* ]]> */
  
  var activeList;
  var newList;
  var duration = 500;
  var activeListHeight;
  var activeListWidth;
  var newListHeight;
  var newListWidth;
  
  
  function showPage(showType, data){
    if (showType == 'normal')
      $('#sf_admin_list').html(data);
    else if (showType == 'append')
      showPageAppend(data);
    else
    {
      activeList = $("#sf_admin_list .active-list");
      activeListHeight = activeList.height();
      activeListWidth = activeList.width();
      activeList.width(activeListWidth);
      activeList.height(activeListHeight);
      
      activeList.addClass('art-absolute');      
      $("#sf_admin_list").width(activeListWidth);
      $("#sf_admin_list").height(activeListHeight);
      $("#sf_admin_list").append(data);

      newList = $("#sf_admin_list .new-list");
      newListHeight = newList.height();
      newListWidth = newList.width();
      newList.width(newListWidth);
      newList.height(newListHeight);
      
      if (showType == 'left' || showType == 'right')
        showPageLeftRight(showType);
      else if (showType == 'top' || showType == 'bottom')
        showPageTopBottom(showType);

      newList.addClass('active-list'); 
      newList.removeClass('new-list'); 
      $("#sf_admin_list").width(newListWidth);
      $("#sf_admin_list").height(newListHeight);
      $("#sf_admin_list").modalIndicator("close");
    }
  }
  
  function showPageAppend(data){
    actualPage++;
    
    if (actualPage == lastPage)
      $("#sf_admin_list tfoot a").remove();
    else
    {
      $("#sf_admin_list").modalIndicator();
      $(data).insertAfter("#sf_admin_list .sf_admin_row:last");
      $("#sf_admin_list").modalIndicator('close');
    }
  }
  
  function showPageLeftRight(showType){
    if (activeListHeight > newListHeight)
      height = activeListHeight;
    else
      height = newListHeight;

    $("#sf_admin_list").height(height);

    if (showType == 'left')
    {
      newList.css('left', -activeListWidth);
      newList.removeClass('art-hide');

      newList.animate({
        left: '+='+activeListWidth
      }, duration);
      activeList.animate({
        left: '+='+activeListWidth
      }, duration, function(){
        animateSuccess();});
    }
    else if (showType == 'right')
    {
      newList.css('left', activeListWidth);
      newList.removeClass('art-hide');

      newList.animate({
        left: '-='+activeListWidth
      }, duration);
      activeList.animate({
        left: '-='+activeListWidth
      }, duration, function(){
        animateSuccess()});
    }
  }
  
  function showPageTopBottom(showType){
    $("#sf_admin_list .new-list").addClass('art-clear-left'); 
    
    if (activeListWidth > newListWidth)
      width = activeListWidth;
    else
      width = newListWidth;

    $("#sf_admin_list").width(width);

    if (showType == 'top')
    {
      newList.css('top', -activeListHeight);
      newList.removeClass('art-hide');

      newList.animate({
        top: '+='+activeListHeight
      }, duration);
      activeList.animate({
        top: '+='+activeListHeight
      }, duration, function(){
        animateSuccess();});
    }
    else if (showType == 'bottom')
    {
      newList.css('top', activeListHeight);
      newList.removeClass('art-hide');

      newList.animate({
        top: '-='+activeListHeight
      }, duration);
      activeList.animate({
        top: '-='+activeListHeight
      }, duration, function(){
        animateSuccess();});
    }
 
  }
  
  function animateSuccess(){
    activeList.remove();
    newList.removeClass('art-absolute');
    newList.css('height', '');
  }
</script>
