<?php

/**
 * pa_gallery actions.
 *
 * @package    testshop
 * @subpackage pa_gallery
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class Pluginpa_galleryActions extends artActions
{

  public function preExecute()
  {
    $request = $this->getRequest();
    $this->model = $request->getParameter('model');
    $this->fkIdValue = $request->getParameter('id');
  }

  public function executeIndex(sfWebRequest $request)
  {
    if (method_exists($this->model . 'Table', 'getBackendGalleryList'))
      $this->photoes = Doctrine::getTable($this->model)->getBackendGalleryList($this->fkIdValue);
    else
    {
      $userCulture = $this->getUser()->getCulture();
      $foreignKeyName = GalleryManagement::getForeignKeyName($this->model);

      $this->photoes = Doctrine_Query::create()
              ->from($this->model . ' p')
              ->leftJoin("p.Translation pt WITH pt.lang='$userCulture'")
              ->where('p.' . $foreignKeyName . ' = ?', $this->fkIdValue)
              ->orderBy('p.order ASC, p.id ASC')
              ->execute();
    }

    $this->newOrder = $this->photoes->count() + 1;

    $this->form = $this->prepareNewPhotoForm($this->newOrder);
  }

  public function executeSaveOrder(sfWebRequest $request)
  {
    if ($request->isMethod('POST'))
    {
      $photoes = $request->getParameter('setOrder');
      $order = 1;

      foreach ($photoes as $photoId)
      {
        if (method_exists($this->model . 'Table', 'updateOrder'))
          Doctrine::getTable($this->model)->updateOrder($photoId, $order);
        else
          Doctrine_Query::create()
                  ->from($this->model)
                  ->update()
                  ->set('order', $order)
                  ->where('id = ?', $photoId)
                  ->execute();

        $order++;
      }

      $this->getUser()->setFlash('notice', 'Dane zostały zapisane pomyślnie.');
    }

    $this->forward('pa_gallery', 'index');
  }

  public function executeDeletePhoto(sfWebRequest $request)
  {
    $photoId = $request->getParameter('photoId');
    $photoObject = Doctrine::getTable($this->model)->find($photoId);
    GalleryManagement::deletePhoto($this->model, $photoObject);
    
    $this->getUser()->setFlash('notice', 'Zdjęcie zostało usunięte!');

    $this->forward('pa_gallery', 'index');
  }

  public function executeNewPhoto(sfWebRequest $request)
  {
    $newOrder = $request->getParameter('new_order');
    $form = $this->prepareNewPhotoForm($newOrder);
    
    if ($request->isMethod('post') && $request->hasParameter($form->getName()))
    {
      $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));

      if ($form->isValid())
        $form->save();
    }

    $this->forward('pa_gallery', 'index');
  }

  protected function prepareNewPhotoForm($newOrder)
  {
    $photoObject = new $this->model();
    $photoObject->setOrder($newOrder);
    $photoObject->__set(GalleryManagement::getForeignKeyName($this->model), $this->fkIdValue);

    $formClass = class_exists('ProjectGalleryManagementForm') ? 'ProjectGalleryManagementForm' : 'GalleryManagementForm';

    return new $formClass($photoObject, array('model' => $this->model, 'fkIdValue' => $this->fkIdValue));
  }

}
