<?php
/**
 * Partial paginatora.
 *
 * @package    partials
 * @subpackage templates/pagination

 * @version    1.0.0
 */
?>

<?php if ($pager->haveToPaginate()): ?>
<div class="pagination">
  <a href="?page=1">
    <span class="first-page"><?php echo __('<<') ?></span>
  </a>
  <a href="?page=<?php echo $pager->getPreviousPage() ?>">
    <span class="previous-page"><?php echo __('<') ?></span>
  </a>
  <?php foreach ($pager->getLinks() as $page): ?>
  <?php if ($page == $pager->getPage()): ?>
    <?php echo $page ?>
    <?php else: ?>
    <a href="?page=<?php echo $page ?>"><?php echo $page ?></a>
    <?php endif; ?>
  <?php endforeach; ?>
  <a href="?page=<?php echo $pager->getNextPage() ?>">
    <span class="last-page"><?php echo __('>') ?></span>
  </a>
  <a href="?page=<?php echo $pager->getLastPage() ?>">
    <span class="last-page"><?php echo __('>>') ?></span>
  </a>
</div>
<?php endif; ?>

<div class="pagination_desc">
  <?php echo __('Ilość elementów: '); ?><strong><?php echo $pager->getNbResults() ?></strong>
  <?php if ($pager->haveToPaginate()): ?>
  - <?php echo __('Strona:'); ?> <strong><?php echo $pager->getPage() ?>/<?php echo $pager->getLastPage(); ?></strong>
  <?php endif; ?>
</div>