<?php
  artEscaper::escape($value, 'Submit');
  artEscaper::escape($aroundTag, 'a');
  artEscaper::escape($aroundTagOptions, array());
  artEscaper::escape($insideTag, 'span');
  artEscaper::escape($insideTagOptions, array());
  artEscaper::escape($inputName, 'save');
  artEscaper::escape($withIcon, false);
  artHtmlHelper::addHtmlClassToArray($aroundTagOptions, 'submit art-input-submit art-pointer');
  
  if (isset($class))
    artHtmlHelper::addHtmlClassToArray($aroundTagOptions, $class);
  
  artEscaper::setDefaultInArray($insideTagOptions, 'onclick', '');
  
  if (isset($formId))
    $insideTagOptions['onclick'] .= " $('#$formId').submit();";
  else
    $insideTagOptions['onclick'] .= " $(this).parent().parent().find('.hidden-submit').click();";
  
  if ($withIcon)
    $value = '<span class="submit-icon"></span><span class="submit-text">' . __($value) . '</span>';
  else
    $value = __($value);
  
  $artBoxContent = content_tag($insideTag, $value, $insideTagOptions);
  
  echo tag($aroundTag, $aroundTagOptions, true);
  echo '<span class="art-hide span-hidden-submit"><input type="submit" name="' .  $inputName . '" class="hidden-submit" /></span>';
  echo artBox::getBox('horizontal_span', $artBoxContent);
  echo '</' . $aroundTag . '>'; 
?>