<script type="text/javascript">
  var foreignKeysArray = new Object(); <?php /* tablica wartości kluczy obcych */ ?>
  var foreignKeysReturnedFromTab = new Object(); <?php /* tablica nazw kluczy obcych zwracanych przez dane zakładki */ ?>
  var requiredsArray = new Object(); <?php /*  tablica wymaganych kluczy obcych potrzebnych do otworzenia danej zakładki*/ ?>
  var hasTabFormArray = new Object(); <?php /* tablica zawierająca informację o tym, czy na danej zakładce jest formularz "tabsowy" */ ?>
  var submitFormOnChangeTab = new Object(); <?php /* tablica sprawdzająca, czy podczas zmiany zakładki robić save na zakładce, której klucz jest w tej tablicy */ ?>
  var activeTab = ''; <?php /* zmienna oznaczająca aktywną zakładkę - tzn tą, w której jesteśmy */ ?>
  var oldTab = ''; <?php /* podczas zmiany aktywnej zakladki pod ta zmienna jest podpisywana zakladka z ktore wychodzimy */ ?>
  var clickedTab = ''; <?php /* zmienna oznaczajaca zakladke, na ktora kliknelismy (i chcemy sie do niej przeniesc) */ ?>
  var enabledCKE = true; <?php /* zmienna wlaczajaca lub wylaczajaca CKEditory na formularzach */ ?>
  var cancelChanges = true; <?php /* zmienna potrzebna do popupa z zapytaniem czy poprawic formularz czy anulowac zmiany podczas bledow walidacji formularza */ ?>
  
  $(function(){
    foreignKeysArray = <?php echo htmlspecialchars_decode($tabsConfiguration->getJavascriptForeignKeysArray()) ?>;
    foreignKeysReturnedFromTab = <?php echo htmlspecialchars_decode($tabsConfiguration->getJavascriptReturnedFromTabArray()) ?>;
    submitFormOnChangeTab = <?php echo htmlspecialchars_decode($tabsConfiguration->getJavascriptSubmitFormOnChangeTabArray()) ?>;
    requiredsArray = <?php echo htmlspecialchars_decode($tabsConfiguration->getJavascriptRequiredForeignKeysArray()) ?>;
    hasTabFormArray = <?php echo htmlspecialchars_decode($tabsConfiguration->getJavascriptTabsHasFormArray()) ?>;
    
    addClickEventsOnTabs();
    changeTab('<?php echo $tabsConfiguration->getFirstTab() ?>');
  });
  
<?php /* dodawanie na wszystkich zakładkach zdarzenia onclick */ ?>
  function addClickEventsOnTabs(){
<?php foreach ($tabsConfiguration->getTabsInOrder() as $tabName): ?>
      $("#tab-form-<?php echo $tabName ?>").click(function(){
        clickOnTab('<?php echo $tabName ?>');
      });
<?php endforeach ?>
  }
  
<?php /* funkcja wywoływana na kliknieciu na akladke */ ?>
  function clickOnTab(tabName){
//    if (!$("#tab-form-" + tabName).hasClass("tab-form-disabled-tab"))
      submitTabForm(tabName); 
  }
  
<?php /* zapis formularza na aktywnej zakladce (o ile jest tam formularz wygenerowany z konfiguracji zakładek */ ?>
  function submitTabForm(tabName){
      clickedTab = tabName;
      
      if (hasTabFormArray[activeTab] && submitFormOnChangeTab[activeTab])
        $("#tabs-form-container #tabs-form-submit").click();
      else
        changeTab(clickedTab);
  }
  
<?php /* funkcja do zmiany zakładki na inną */ ?>
  function changeTab(tabName){
    if (tabName != '' && issetRequiredForeignKeysForTab(tabName))
    {
      oldTab = activeTab;

      if (oldTab != '')
        $("#tab-form-" + oldTab).removeClass('tab-form-active-tab');

      $("#tab-form-" + tabName).addClass('tab-form-active-tab');
      $("#tabs-form-container").removeClass('tabs-form-container-' + oldTab);
      $("#tabs-form-container").addClass('tabs-form-container-' + tabName);
      activeTab = tabName;

      $.ajax({
        type: 'POST',
        url: '<?php echo $tabsConfiguration->getUrl() ?>' + tabName + getForeignKeysUrlString(),
        beforeSend:function(XMLHttpRequest){
          getTabIndicator();
        },
        success: function(data){
          closeTabIndicator();
          $('#tabs-form-container').html(data);
          runCKEditor();
        }
      });
      
      clickedTab = '';
      
      return true;
    }
    else
    {
      clickedTab = '';
      
      return false;
    }
  }
  
  function getTabIndicator(){
    $('#tabs-form-container').modalIndicator();
  }
  
  function closeTabIndicator(){
//    $('#tabs-form-container').artIndicatorClose();
  }
  
<?php /* funkcja do pobierania stringa z ustawionymi kluczami obcymi. String doklejany jest pozniej do urla */ ?>
  function getForeignKeysUrlString(){
    var foreignKeysUrlString = '?';
    
    for(var key in foreignKeysArray)
      if (foreignKeysArray[key] !== null)
        foreignKeysUrlString += key + '=' + foreignKeysArray[key] + '&';
    
    return foreignKeysUrlString.substr(0, foreignKeysUrlString.length - 1);
  }
  
<?php /* funkcja sprawdza, czy wymagane do odpalenia zakladki klucze sa ustawione (sa różne od null) */ ?>
  function issetRequiredForeignKeysForTab(tabName){
    var issetRequireds = true;
    
    $.each(requiredsArray[tabName], function(key, value) {
      if(foreignKeysArray[requiredsArray[tabName][key]] == null)
        issetRequireds = false; //alert('Brak wszystkich wymaganych elementów do otworzenia zakładki!');
    });

    return issetRequireds;
  }
  
<?php /*  funkcja wywoływana po pomyślnym zapisaniu formularza*/ ?>
  function successSubmitTabForm(data){
    $("#tabs-form-container").html(data);
    var returnForeignKey = foreignKeysReturnedFromTab[activeTab];
    
    if(returnForeignKey != null)
    {
      var element = $("#tab-form-foreign-key-" + returnForeignKey);
      
<?php /* jeżeli istnieje ukryty div z wartością klucza obcego */ ?>
      if (element.length != 0)
      {
<?php /*  to dodaj go do tablicy kluczy obcych */ ?>
        foreignKeysArray[foreignKeysReturnedFromTab[activeTab]] = element.html();
<?php /* zaktywuj zakładki */ ?>
        enableTabs();
<?php /* zmien zakladke na klikniętą */ ?>
        runCKEditor();
        changeTab(clickedTab);
      }
      else
      {
        if (clickedTab != '')
        {
<?php /* jeżeli submit na formularzu nastąpił poprzez próbę przejścia do innej zakładki */ ?>
<?php /* a użytkownik chce anulować wprowadzanie zmian */ ?>
          cancelChanges = true;
          runCKEditor();
          getConfirmPopup();
        }
        else
          runCKEditor();
      }
    }
    
  }
  
  function afterCloseConfirmPopup(){
    if(!cancelChanges)
      runCKEditor();
    else
    {
<?php /* próbujemy go przenieść do klikniętej zakładki */ ?>
      if (!changeTab(clickedTab))
<?php /* jeżeli się nie uda, to ponownie renderujemy mu zakładkę, w której jest */ ?>
        changeTab(activeTab);
    }
  }
  
  function enableTabs(){
    for (var tab in requiredsArray)
    {
      var enableTab = true;
      
      for (var requiredKey in requiredsArray[tab])
        if (foreignKeysArray[requiredsArray[tab][requiredKey]] == null)
          enableTab = false;
      
      if (enableTab)
        $("#tab-form-" + tab).removeClass("tab-form-disabled-tab");
      else
        $("#tab-form-" + tab).addClass("tab-form-disabled-tab");
    }
  }
  
<?php /* wywołanie popupa z zapytaniem "Poprawić formularz czy anulować zmiany?". Popup powstaje wtedy, gdy
* zmieniamy zakładkę i nie zostaną zapisane pomyślnie zmiany w formularzu aktywnej zakładki */ ?>
  function getConfirmPopup(){
      $('#tabs-form-confirm-popup').dialog({
      autoOpen: true,
      modal: true,
      closeOnEscape: true,
      draggable: true,
      buttons: { 
        "<?php echo __('Popraw') ?>": function(){
          cancelChanges = false;
          $(this).dialog("close"); 
        },
        "<?php echo __('Anuluj') ?>": function(){
          cancelChanges = true;
          $(this).dialog("close"); 
        }
      },
      close: function(event, ui) {
        afterCloseConfirmPopup();
      }
    });
  }
  
  function runCKEditor(){
    if (enabledCKE)
    {
      var canVarCKE = true;
      
      $('textarea:not(.no-ckeditor)').each(function(){
        if($("#cke_" + $(this).attr('id')).length > 0)
          canVarCKE = false;
      });
          
      if(canVarCKE)
        getCKEInstances();
      
      return canVarCKE;
    }
      
  }
</script>

<div id="tabs-form-confirm-popup" class="art-hide">
  <?php echo __('Improve the form or cancel changes?') ?>
</div>