DROP PROCEDURE IF EXISTS add_to_categories;
DELIMITER //
CREATE PROCEDURE add_to_categories
(
      IN _user_id BIGINT,
      IN _internal_messages_ids VARCHAR(8000),
      IN _internal_categories_ids VARCHAR(8000)
)
BEGIN
  
  DECLARE _internal_message_id VARCHAR(64);
  DECLARE _internal_category_id VARCHAR(64);
  DECLARE _loop1 INT;
  DECLARE _loop2 INT;
  SET @str_insert = '';

  START TRANSACTION;

  SET _loop1 = 1;

  LOOP1: loop
    SET _loop2 = 1;

    SELECT split_str(_internal_messages_ids,',',_loop1) INTO _internal_message_id;

    IF _internal_message_id IS NULL OR _internal_message_id = '' THEN
      LEAVE LOOP1;
    END IF;

    LOOP2: loop
      SELECT split_str(_internal_categories_ids,',',_loop2) INTO _internal_category_id;

      IF _internal_category_id IS NULL OR _internal_category_id = '' THEN
        LEAVE LOOP2;
      END IF;

      DELETE FROM internal_message_category WHERE user_id=_user_id AND internal_message_id=_internal_message_id AND internal_category_id=_internal_category_id;
      SET @str_insert = CONCAT (@str_insert, ',(', _user_id, ', ', _internal_message_id, ', ', _internal_category_id, ')' );

      SET _loop2 = _loop2 + 1;
    END LOOP LOOP2;

    SET _loop1 = _loop1 + 1;
  END LOOP LOOP1;

  SET @str_insert = SUBSTRING(@str_insert, 2);
  IF (@str_insert <> '') THEN
      SET @str_insert = CONCAT ('INSERT INTO internal_message_category(user_id, internal_message_id, internal_category_id) VALUES ', @str_insert);
      PREPARE stmt1 FROM @str_insert;
      EXECUTE stmt1;
   END IF;

  COMMIT;
END //
DELIMITER ;