DROP PROCEDURE IF EXISTS add_user_tag;
DELIMITER //
CREATE PROCEDURE add_user_tag
(
      IN _user_tag_name VARCHAR(250),
      IN _user_email VARCHAR(255),
      IN _user_tag_description VARCHAR(2000)
)
BEGIN
  DECLARE _user_tag_id BIGINT;
  DECLARE _guard_user_id BIGINT;
  DECLARE _newsletter_user_id BIGINT;
  DECLARE _tmp_id BIGINT;
  
  
  START TRANSACTION;

  SELECT id FROM user_tag WHERE name=  _user_tag_name INTO _user_tag_id;

  IF _user_tag_id is null THEN
    INSERT INTO user_tag VALUES (NULL, _user_tag_name,_user_tag_description);
    SELECT LAST_INSERT_ID() INTO _user_tag_id;
  END IF;

  SELECT id FROM sf_guard_user WHERE email_address=  _user_email INTO _guard_user_id;
  
  IF _guard_user_id IS NOT null THEN    
    SET _tmp_id = NULL;
    select id from guard_user_tag where user_id=_guard_user_id AND user_tag_id = _user_tag_id INTO _tmp_id;
    IF _tmp_id IS null THEN    
      INSERT INTO guard_user_tag (id,user_id, user_tag_id,created_at,updated_at,deleted_at) 
        VALUES (NULL, _guard_user_id, _user_tag_id,now(),now(),NULL);
    ELSE
      UPDATE guard_user_tag SET updated_at=now(), deleted_at=NULL WHERE id = _tmp_id;
    END IF;
  END IF;
  
  SELECT id FROM newsletter_user WHERE email=  _user_email INTO _newsletter_user_id;
  IF _newsletter_user_id IS NOT null THEN    
    SET _tmp_id = NULL;
    select id from newsletter_user_tag where newsletter_user_id=_newsletter_user_id AND user_tag_id = _user_tag_id INTO _tmp_id;
    IF _tmp_id IS null THEN    
      INSERT INTO newsletter_user_tag (id,newsletter_user_id, user_tag_id,created_at,updated_at,deleted_at) 
        VALUES (NULL, _newsletter_user_id, _user_tag_id,now(),now(),NULL);
    ELSE
      UPDATE newsletter_user_tag SET updated_at=now(), deleted_at=NULL WHERE id = _tmp_id;
    END IF;
  END IF;
  
  

  COMMIT;

END //
DELIMITER ;