DROP PROCEDURE IF EXISTS move_to_categories;
DELIMITER //
CREATE PROCEDURE move_to_categories
(
      IN _user_id BIGINT,
      IN _internal_messages_ids VARCHAR(8000),
      IN _internal_categories_ids VARCHAR(8000),
      IN _old_category_id INT
)
BEGIN

  START TRANSACTION;

  SET @delete = CONCAT ('DELETE FROM internal_message_category WHERE user_id=', _user_id);
  SET @delete = CONCAT (@delete, ' AND internal_message_id IN (', _internal_messages_ids,') AND internal_category_id=', _old_category_id);
  PREPARE stmt1 FROM @delete;
  EXECUTE stmt1;

  call add_to_categories(_user_id, _internal_messages_ids, _internal_categories_ids);

  COMMIT;

END //
DELIMITER ;