DROP PROCEDURE IF EXISTS remove_user_tag;
DELIMITER //
CREATE PROCEDURE remove_user_tag
(
      IN _user_tag_name VARCHAR(250),
      IN _user_email VARCHAR(255)
)
BEGIN
  DECLARE _user_tag_id BIGINT;
  DECLARE _guard_user_id BIGINT;
  DECLARE _newsletter_user_id BIGINT;
  
  START TRANSACTION;

  SELECT id FROM user_tag WHERE name=  _user_tag_name INTO _user_tag_id;

  IF _user_tag_id IS NOT null THEN

    SELECT id FROM sf_guard_user WHERE email_address=  _user_email INTO _guard_user_id;

    IF _guard_user_id IS NOT null THEN    
      UPDATE guard_user_tag SET deleted_at=NOW() WHERE user_id=_guard_user_id AND user_tag_id = _user_tag_id;
    END IF;

    SELECT id FROM newsletter_user WHERE email=  _user_email INTO _newsletter_user_id;
    IF _newsletter_user_id IS NOT null THEN    
      UPDATE newsletter_user_tag SET deleted_at=NOW() WHERE newsletter_user_id=_newsletter_user_id AND user_tag_id = _user_tag_id;
    END IF;

  END IF;
 
  COMMIT;

END //
DELIMITER ;