DROP PROCEDURE IF EXISTS send_newsletter_to_database;
DELIMITER //
CREATE PROCEDURE send_newsletter_to_database
(
      IN _message_center_id BIGINT,
      IN _max_message_count INT,
      IN _number_of_emails_to_send INT
)
BEGIN
  START TRANSACTION;

  SET @_st = CONCAT('CREATE TEMPORARY TABLE  temp_users (id bigint(20), PRIMARY KEY (`id`)) AS SELECT id FROM newsletter_user where status = 2 AND message_count <= ',_max_message_count,' 
          ORDER BY id LIMIT ', _number_of_emails_to_send);
  PREPARE stmt FROM @_st; 
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;

  UPDATE newsletter_user nu join temp_users t on t.id=nu.id SET nu.status = 4;
  
  INSERT INTO message_multisend_list 
      SELECT NULL, _message_center_id, 3, NULL, nu.id, now(), now() FROM newsletter_user nu join temp_users t on t.id=nu.id;

  COMMIT;

END //
DELIMITER ;