DROP PROCEDURE IF EXISTS send_newsletter_to_list;
DELIMITER //
CREATE PROCEDURE send_newsletter_to_list
(
      IN _message_center_id BIGINT,
      IN _max_message_count INT,
      IN _emails_list varchar(21000)
)
BEGIN
  START TRANSACTION;
  CREATE TEMPORARY TABLE  temp_emails (email varchar(255), UNIQUE KEY (`email`))ENGINE=InnoDB  DEFAULT CHARSET=utf8;

  SET @_st = CONCAT('INSERT INTO temp_emails values ', _emails_list);
  PREPARE stmt FROM @_st; 
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;

  -- DODAJE NIEISTNIEJĄCE MAILE DO NEWSLETTER USER
  CREATE TEMPORARY TABLE  temp_emails_2 (email varchar(255), UNIQUE KEY (`email`)) AS SELECT t.email FROM temp_emails t 
      LEFT OUTER JOIN newsletter_user nu on t.email=nu.email WHERE nu.email IS NULL;
  
  INSERT INTO newsletter_user (email,first_name,last_name,status,created_at,updated_at) SELECT email,"","",3,now(),now() FROM temp_emails_2;


  -- aktualizuje user_id w newsletter user
  
  CREATE TEMPORARY TABLE  temp_users (id bigint(20), PRIMARY KEY (`id`)) AS SELECT u.id FROM sf_guard_user u join temp_emails e on e.email = u.email_address 
      LEFT OUTER JOIN newsletter_user nu ON nu.user_id = u.id WHERE nu.user_id IS NULL;
  
  UPDATE newsletter_user nu JOIN sf_guard_user u ON u.email_address = nu.email SET nu.user_id = u.id, nu.first_name = u.first_name,nu.last_name = u.last_name WHERE nu.user_id IS NULL;
  
  IF _max_message_count >= 0 THEN
    INSERT INTO message_multisend_list 
      SELECT NULL, _message_center_id, 3, NULL, nu.id, now(), now() FROM newsletter_user nu join temp_emails t on t.email=nu.email WHERE nu.message_count <= _max_message_count;
  ELSE
    INSERT INTO message_multisend_list 
      SELECT NULL, _message_center_id, 3, NULL, nu.id, now(), now() FROM newsletter_user nu join temp_emails t on t.email=nu.email;
  END IF;

  COMMIT;

END //
DELIMITER ;