DROP PROCEDURE IF EXISTS sync_user_tag;
DELIMITER //
CREATE PROCEDURE sync_user_tag
(
      IN _user_email VARCHAR(255)
)
BEGIN
  DECLARE _user_tag_id BIGINT;
  DECLARE _guard_user_id BIGINT;
  DECLARE _newsletter_user_id BIGINT;
  
  START TRANSACTION;

  

  SELECT id FROM sf_guard_user WHERE email_address=  _user_email INTO _guard_user_id;
  SELECT id FROM newsletter_user WHERE email=  _user_email INTO _newsletter_user_id;
  
  IF _guard_user_id IS NOT null AND _newsletter_user_id IS NOT null THEN   
    INSERT INTO guard_user_tag (id,user_id, user_tag_id,created_at,updated_at,deleted_at) 
      SELECT gut.id, _guard_user_id, nut.user_tag_id, now(),now(), NULL FROM 
          (SELECT * FROM newsletter_user_tag WHERE newsletter_user_id = _newsletter_user_id AND deleted_at IS NULL) nut 
          LEFT OUTER JOIN (SELECT * FROM guard_user_tag WHERE user_id = _guard_user_id) gut ON gut.user_tag_id=nut.user_tag_id
        WHERE (gut.user_id = _guard_user_id OR gut.user_id IS NULL) AND nut.newsletter_user_id = _newsletter_user_id 
      ON DUPLICATE KEY UPDATE updated_at=now(), deleted_at=NULL;

    INSERT INTO newsletter_user_tag (id,newsletter_user_id, user_tag_id,created_at,updated_at,deleted_at) 
      SELECT nut.id, _newsletter_user_id, gut.user_tag_id, now(),now(), NULL FROM 
        (SELECT * FROM guard_user_tag WHERE user_id = _guard_user_id AND deleted_at IS NULL) gut 
        LEFT OUTER JOIN (SELECT * FROM newsletter_user_tag WHERE newsletter_user_id = _newsletter_user_id ) nut ON gut.user_tag_id=nut.user_tag_id
        WHERE (nut.newsletter_user_id = _newsletter_user_id OR nut.newsletter_user_id IS NULL) AND gut.user_id = _guard_user_id 
      ON DUPLICATE KEY UPDATE updated_at=now(), deleted_at=NULL;

   
  END IF;
  
  
  
 
  COMMIT;

END //
DELIMITER ;