<?php
/**
 * Description of BaseMessageChannel
 *
 
 */

class AbstractMessageChannel
{
    public $sendStatus = true;

    /**
     * @param $sendInfo
     * @param $message
     * @param $title
     */
    public function __construct($sendInfo, $message, $title)
    {
        $message = htmlspecialchars_decode($message);
        $title = htmlspecialchars_decode($title);

        $this->send($sendInfo, $message, $title);
    }

    public function send($sendInfo, $message, $title)
    {

    }

    /**
     * Metoda zapisuje historię wysłanych emaili
     * @param type $sendInfo - dane wysyłania z kanału
     * @param type $message - treść wiadomości
     * @param type $title - tytuł wiadomości
     * @param type $sendStatus - status wysyłania z send
     * @param type $failedRecipients - odbiorcy do których nie doszły emaile
     */
    public function saveHistory($messageMultisendList, $message, $title, $sendStatus, $failedRecipients = null, $error = null)
    {
        $object = new MessageMultisendHistory();
        $object->setTitle($title);
        $object->setDescription($message);
        $object->setMessageCenterId($messageMultisendList->getMessageCenterId());
        $object->setMessageMultisendTypeId($messageMultisendList->getMessageMultisendTypeId());

        if (!is_null($messageMultisendList->getUserId()))
            $object->setUserId($messageMultisendList->getUserId());
        else
            $object->setNewsletterUserId($messageMultisendList->getNewsletterUserId());

        if ($sendStatus === false) {
            $object->setStatus(MessageMultisendHistory::_SEND_ERROR);
            $object->setError("SEND ERROR - FAILED RECIPIENTS: ", implode(";", $failedRecipients));
        } else {
            if (!(count($failedRecipients) > 0))
                $object->setStatus(MessageMultisendHistory::_SEND_OK);
            else {
                $object->setStatus(MessageMultisendHistory::_SEND_PARTIAL_ERROR);
                $object->setError("PARTIAL SEND ERROR - FAILED RECIPIENTS: ", implode(";", $failedRecipients));
            }
        }

        if ($error != null) {
            $object->setError($error);
        }

        $object->save();
    }

    /**
     * Metoda dołącza obrazki z layoutu (z body wiadomości) do emaila i podmienia <img src= na adres wew. emaila (cid)
     * @param type $message
     * @param type $messageBody
     * @param type $withExternalImg - czy ma załadowywać zewnętrzne obrazki - rozpoczynające się od http (default false)
     * @return type
     */
    public function addEmbedFilesToLayout($message, $messageBody, $withExternalImg = false)
    {
        $cidArray = array(); //tablica do przechowywania cid'ow - adresów obrazka wewnątrz maila - aby nie ładować tego samego obrazka kilka razy

        preg_match_all('@<img[\n\t\r ]*.*?[\n\t\r ]*(src[\n\t\r ]*=[\n\t\r ]*[\'"]{1,1}(.*?)[\'"]{1,1})@', $messageBody, $matchesarray);

        foreach ($matchesarray[2] as $k => $img) {
            if (empty($img))
                continue;

            if (!artString::startsWith('http', $img))
                $file = sfConfig::get('sf_web_dir') . '/' . $img;
            else {
                if ($withExternalImg) //czy załączać do emaila obrazki z zewnętrznych serwerów?
                    $file = $img;
                else
                    continue;
            }

            if (!isset($cidArray[$file]))
                $cidArray[$file] = $message->embed(Swift_Image::fromPath($file));

            $m = str_replace($matchesarray[1][$k], 'src="' . $cidArray[$file] . '"', $messageBody);
            $messageBody = $m;
        }

        return $messageBody;
    }

    /**
     * Załącza pliki do emaila
     * @param type $message
     * @param type $attachments
     * @param type $withExternalAttachments - czy ma załączać pliki z zew. serwerów (default nie)
     * @return type
     */
    public function addAttachments($message, $attachments, $withExternalAttachments = false)
    {
        $cidArray = array(); //tablica do przechowywania cid'ow - adresów plików wewnątrz maila - aby nie ładować tego samego obrazka kilka razy

        foreach ($attachments as $k => $attachment) {
            if (empty($attachment))
                continue;

            if (!artString::startsWith('http', $attachment))
                $file = sfConfig::get('sf_web_dir') . '/' . $attachment;
            else {
                if ($withExternalAttachments) //czy załączać do emaila obrazki z zewnętrznych serwerów?
                    $file = $attachment;
                else
                    continue;
            }

            if (!isset($cidArray[$file]))
                $cidArray[$file] = $message->embed(Swift_Image::fromPath($file));
        }
    }

    public function getSendStatus()
    {
        return $this->sendStatus;
    }

}
