<?php
/**
 * Description of MessageChannelEmail
 *
 
 */
class MessageChannelEmail extends AbstractMessageChannel
{
    /**
     * @param $sendInfo
     * @param $message
     * @param $title
     */
    public function send($sendInfo, $message, $title)
    {
        $msg = new Swift_Message($title);
        $msg->setTo($sendInfo['destination_email']);
        $msg->setFrom($sendInfo['source_email']);

        $message = $this->addEmbedFilesToLayout($msg, $message);

        $msg->setBody($message, "text/html");
        $this->addAttachments($msg, $sendInfo['attachments']);

        $mailer = sfContext::getInstance()->getMailer();
        $mailer->sendNextImmediately()->send($msg);
    }

}
