<?php
/**
 * Description of MessageChannelEmail
 *
 
 */
class MessageChannelEmailNewsletter extends AbstractMessageChannel
{

    /**
     * @param $sendInfo
     * @param $message
     * @param $title
     */
    public function send($sendInfo, $message, $title)
    {
        try {
            $failedRecipients = array();
            $msg = new Swift_Message($title);
            $msg->setTo($sendInfo['destination_email']);
            $msg->setFrom($sendInfo['source_email']);

            $message = $this->addEmbedFilesToLayout($msg, $message);
            $msg->setBody($message, "text/html");

            $this->addAttachments($msg, $sendInfo['attachments']);

            $mailer = sfContext::getInstance()->getMailer();

            $this->sendStatus = $mailer->sendNextImmediately()->send($msg, $failedRecipients);


            artDebug::logNotice("SendEmail To:" . $sendInfo['destination_email'] . " From:" . $sendInfo['source_email']);


        } catch (Exception $e) {
            $this->error = "Exception: " . $e->getMessage();
        }

        if (!isset($sendInfo['params']['messageMultisendList']))
            return;

        $messageMultisendList = $sendInfo['params']['messageMultisendList'];

        if (isset($this->error) && isset($messageMultisendList)) {
            $this->saveHistory($messageMultisendList, $message, $title, $this->sendStatus, $failedRecipients, $this->error);
        } elseif (isset($messageMultisendList)) {
            $this->saveHistory($messageMultisendList, $message, $title, $this->sendStatus, $failedRecipients);
            $newsletterUser = $messageMultisendList->getNewsletterUser();
            if ($newsletterUser) {

                if ($messageMultisendList->getMessageCenter())
                    $description = $messageMultisendList->getMessageCenter()->getUniqueName();

                if (!isset($description) || $description == '')
                    $description = 'newsletter';

                if (MessengerSettings::hasTags())
                    UserTag::addTagNewsletterUser("NEWSLETTER_MESSAGE_ID_" . $messageMultisendList->getMessageCenterId(),
                        $newsletterUser, $description);
                //$newsletterUser = new NewsletterUser();
                $newsletterUser->setMessageCount($newsletterUser->getMessageCount() + 1);
                if ($newsletterUser->getStatus() == NewsletterUser::_EMAIL_FROM_DATABASE_SENDING)
                    $newsletterUser->setStatus(NewsletterUser::_EMAIL_FROM_DATABASE);

                if ($newsletterUser->getUserId() == null)
                    $newsletterUser->setSfGuardUser(null);

                $newsletterUser->save();
            }
        }

        if (!isset($sendInfo['params']['not_delete_from_list']) && (isset($messageMultisendList) || isset ($this->error)))
            MessageMultisendListTable::addToDeleteMessageList($messageMultisendList->getId());

        Doctrine_Core::getTable('MessageMultisendList')->deleteMessageList();
    }
}
