<?php
/**
 
 */

class MessageChannelInternal extends AbstractMessageChannel
{
    /**
     * @param $sendInfo
     * @param $message
     * @param $title
     */
    public function send($sendInfo, $message, $title)
    {
        $receiverId = isset($sendInfo['destination_internal']) ? $sendInfo['destination_internal'] : null;
        $authorId = isset($sendInfo['source_internal']) ? $sendInfo['source_internal'] : null;

        $messageObject = InternalMessage::createNewMessage($title, $message, $authorId, $receiverId);
        $messageId = $messageObject->getId();

        if (!is_null($receiverId))
            foreach ($sendInfo['internal_categories'] as $categoryId)
                InternalMessageCategory::addObject($messageId, $categoryId, $receiverId);
    }
}
