<?php

/**
 * PluginMessageCenter form.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage filter
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: sfDoctrineFormFilterPluginTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
abstract class PluginMessageCenterFormFilter extends BaseMessageCenterFormFilter
{

  public function setup()
  {
    $this->setWidgets(array(
        'message_channel_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'MessageChannel', 'method' => 'getTranslateChannel')),
        'layout_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'Layout')),
        'unique_name' => new sfArtWidgetFormFilterInput(array('label'=>__('Nazwa unikalna'), 'with_empty' => false)),
        'title' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
    ));

    $this->setValidators(array(
        'message_channel_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => 'MessageChannel', 'column' => 'id', 'multiple' => true)),
        'layout_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => 'Layout', 'column' => 'id', 'multiple' => true)),
        'unique_name' => new sfValidatorPass(array('required' => false)),
        'title' => new sfValidatorPass(array('required' => false, 'trim' => true)),
    ));

    $this->widgetSchema->setNameFormat('message_center_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();
  }
  
  public function addTitleColumnQuery($query, $field, $values) {
    $fieldName = $this->getFieldName($field);
    
    if (is_array($values) && isset($values['text']) && '' != $values['text'])
    {
      $query->addWhere(sprintf('mtt.%s LIKE ?', $fieldName), '%'.$values['text'].'%');
    }

    return $query;
  }

}
