<?php

/**
 * PluginMessageMultisendHistory form.
 *
 * @package    ##PROJECT_NAME##
 * @author     ##AUTHOR_NAME##
 */
abstract class PluginMessageMultisendHistoryFormFilter extends BaseMessageMultisendHistoryFormFilter
{

    public function setup()
    {
        $this->setWidgets(array(
            'email' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
            'name' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
            'title' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
            'description' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
            'errors' => new sfArtWidgetFormFilterBoolRadio(),
            'created_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture())),
        ));

        $this->setValidators(array(
            'email' => new sfValidatorPass(array('required' => false)),
            'name' => new sfValidatorPass(array('required' => false)),
            'title' => new sfValidatorPass(array('required' => false)),
            'description' => new sfValidatorPass(array('required' => false)),
            'errors' => new sfArtValidatorFormLogic(array('with_empty' => true)),
            'created_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
        ));

        $this->widgetSchema->setNameFormat('message_multisend_history_filters[%s]');
        $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
        $this->setupInheritance();
    }

    public function addEmailColumnQuery(Doctrine_Query $query, $field, $values)
    {
        if (is_array($values) && isset($values['text']) && '' != $values['text']) {
            $rootAlias = $query->getRootAlias();

            $query->addWhere('(' . $rootAlias . '.newsletter_user_id IN (SELECT nu.id FROM NewsletterUser nu WHERE nu.email LIKE ? ) OR ' . $rootAlias . '.newsletter_user_id IS NULL )', array('%' . $values['text'] . '%'));
            $query->addWhere('(' . $rootAlias . '.user_id IN (SELECT u.id FROM sfGuardUser u WHERE u.email_address LIKE ? ) OR ' . $rootAlias . '.user_id IS NULL )', array('%' . $values['text'] . '%'));
        }
    }

    public function addNameColumnQuery(Doctrine_Query $query, $field, $values)
    {
        if (is_array($values) && isset($values['text']) && '' != $values['text']) {
            $rootAlias = $query->getRootAlias();

            $query->addWhere($rootAlias . '.message_center_id IN (SELECT m.id FROM MessageCenter m WHERE m.unique_name like ?)', array('%' . $values['text'] . '%'));
        }
    }

    public function addErrorsColumnQuery(Doctrine_Query $query, $field, $values)
    {
        if (isset($values)) {
            $rootAlias = $query->getRootAlias();
            if ($values == 0)
                $query->addWhere($rootAlias . '.error IS NULL ');
            else
                $query->addWhere($rootAlias . '.error IS NOT NULL');
        }
    }
}
