<?php

/**
 * PluginNewsletterUser form.
 *
 * @package    ##PROJECT_NAME##
 * @author     ##AUTHOR_NAME##
 */
abstract class PluginNewsletterUserFormFilter extends BaseNewsletterUserFormFilter
{

    public function setup()
    {
        parent::setup();

        $this->widgetSchema['status'] = new sfArtWidgetFormJQueryMultiSelect(array('choices' => NewsletterUser::getStatusKeys(), 'multiple' => true));
        $this->widgetSchema['message_count'] = new sfArtWidgetFormIntervalFilterInput();

        $this->validatorSchema['status'] = new sfValidatorPass();
        $this->validatorSchema['message_count'] = new sfValidatorSchemaFilter('text', new sfValidatorString(array('required' => false)));

        unset($this['updated_at'], $this['created_at']);

        $this->widgetSchema->setNameFormat('newsletter_user_filters[%s]');
        $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    }

    public function addMessageCountColumnQuery(Doctrine_Query $query, $field, $values)
    {
//    if (isset($values['text']) && '' != $values['text'])
        return sfArtWidgetFormIntervalFilterInput::addColumnQuery($query, $field, $values);
    }

    public function addStatusColumnQuery(Doctrine_Query $query, $field, $values)
    {
        if (is_array($values)) {
            $rootAlias = $query->getRootAlias();
            $query->andWhereIn($rootAlias . '.status', $values);

        }

    }
}
