<?php

/**
 * Description of EditInternalCategoryForm
 *
 
 */
class AjaxInternalCategoryForm extends BaseInternalCategoryForm
{

  public function configure()
  {
    $this->setWidgets(array(
        'id' => new sfWidgetFormInputHidden(),
        'name' => new sfWidgetFormInputText(array(), array('size' => 15)),
    ));

    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'name' => new sfValidatorString(array('max_length' => 100)),
    ));
  
    $this->widgetSchema->setLabel('name', false);
    $this->widgetSchema->setNameFormat('internal_category[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
  }
  
  public function save($con = null)
  {
    if ($this->isNew())
    {
      $this->values['user_id'] = self::getUserId();
      $this->values['order'] = 100;
      $this->values['created_at'] = artDate::today();
    }
    
    $this->values['updated_at'] = artDate::today();
    
    return parent::save($con);
  }

}
