<?php

class PluginAddUserNewsletter extends BaseNewsletterUserForm
{

  public function setup()
  {
    $this->setWidgets(array(
        'email' => new sfArtWidgetFormInputText(),
        'first_name' => new sfArtWidgetFormInputText(),
        'last_name' => new sfArtWidgetFormInputText(),
    ));
    $this->setValidators(array(
        'email' => new sfArtValidatorEmail(array('required' => true), array('invalid' => 'Adres email jest niepoprawny')),
        'first_name' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
        'last_name' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(new sfValidatorDoctrineUnique(
                    array('model' => 'NewsletterUser', 'column' => array('email')),
                    array('invalid' => 'Podany adres e-mail już istnieje.')
    ));

    $this->widgetSchema->setNameFormat('newsletter_user[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function save($con = null)
  {
    $this->values['status'] = NewsletterUser::_INACTIVE;
    $newsletterUser = parent::save($con);
    
    ArtSimpleMessenger::sendActivateNewsletterMessage($newsletterUser);

    return $newsletterUser;
  }
}