<?php

/**
 * Description of PluginBackendNewsletterUserForm
 *
 
 */
class PluginBackendNewsletterUserForm extends BaseNewsletterUserForm
{

    public function setup()
    {
        parent::setup();

        unset($this['created_at'], $this['updated_at']);

        if ($this->isNew())
            unset($this['user_id']);

        if ($this->isEmbedGuard()) {
            unset($this['user_id']);
            $formClass = 'UserAdminForm';

            if (!class_exists('UserAdminForm'))
                $formClass = 'Plugin' . $formClass;

            $this->embedForm('User', new $formClass($this->getObject()->getSfGuardUser()));
        }

        $this->widgetSchema['status'] = new sfArtWidgetFormJQueryMultiSelect(array('choices' => NewsletterUser::getStatusKeys()));
    }

    public function getLevelsArray()
    {
        $levels = array();

        $levels[] = array('status');
        $levels[] = array('email');
        $levels[] = array('first_name');
        $levels[] = array('last_name');

        if ($this->isEmbedGuard())
            $levels[] = array('User');
        else
            $levels[] = array('user_id');

        return $levels;
    }

    public function isEmbedGuard()
    {
        return !$this->isNew() && $this->getObject()->getIsRegistered();
    }

}
