<?php

/**
 * Description of PluginNewsletterMessageCenterForm
 *
 
 */
class PluginNewsletterMessageCenterForm extends BaseMessageCenterForm {

  public function setup() {
    $this->setWidgets(array(
        'id' => new sfWidgetFormInputHidden(),
        'message_channel_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('MessageChannel'), 'add_empty' => false)),
        'layout_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Layout'), 'add_empty' => true)),
        'unique_name' => new sfArtWidgetFormInputText(),
        'collector_class' => new sfArtWidgetFormInputText(),
    ));

    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'message_channel_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('MessageChannel'))),
        'layout_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Layout'), 'required' => false)),
        'unique_name' => new sfValidatorString(array('max_length' => 45, 'required' => false)),
        'collector_class' => new sfValidatorString(array('max_length' => 100)),
    ));

    if (!artSettings::isDevEnvironment())
      unset($this['message_channel_id'], $this['collector_class'], $this['unique_name']);
    $this->widgetSchema->setNameFormat('message_center[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

}
