<?php

/**
 * Description of PluginNewsletterMessageCenterForm
 *
 
 */
class PluginNewsletterMessageTemplateForm extends PluginMessageTemplateForm {

  public function setup() {
    parent::setup();
    
    $this->embedForm('message_center', new MessageCenterForm( $this->getObject()->getMessageCenter() ) );
    unset(
      $this->widgetSchema['message_center']['channel_enabled'],
      $this->widgetSchema['message_center']['message_channel_id'],
      $this->widgetSchema['message_center']['layout_id'],
      $this->widgetSchema['message_center']['collector_class'],
      $this->validatorSchema['message_center']['channel_enabled'],
      $this->validatorSchema['message_center']['message_channel_id'],
      $this->validatorSchema['message_center']['layout_id'],
      $this->validatorSchema['message_center']['collector_class']
    );
    $this->widgetSchema->setLabel('message_center', false);
    
    $this->widgetSchema->setNameFormat('pa_newsletter[%s]');
    
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    
    $this->setupInheritance();
  }

}
