<?php

/**
 * Description of PluginSendToAllImmediatelyForm
 *
 
 */
class PluginSendToAllImmediatelyForm extends BaseForm
{

  public function configure()
  {
    $this->setWidgets(array(
        'text' => new sfArtWidgetFormText(array('content' => 'Wyślij newsletter do wszystkich natychmiast.'))
    ));

    $this->widgetSchema->setLabel('text', false);

    $this->widgetSchema->setNameFormat('send_to_all_immediately[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
  }

  public function save($con = null)
  {
    $messageCenterId = $this->getRequest()->getParameter('id');
    MessageMultisendList::fillListForNewsletterToAll($messageCenterId);
    $sendedCount = ArtMessenger::multisend();
    
    sfConfig::set('sended_count', $sendedCount);
  }

}
