<?php

/**
 * Description of PluginTestSendForm
 *
 
 */
class PluginTestSendForm extends BaseForm
{
  public function configure()
  {
    $this->setWidgets(array(
        'email' => new sfArtWidgetFormInputText(),
        'first_name' => new sfArtWidgetFormInputText(),
        'last_name' => new sfArtWidgetFormInputText()
    ));
    
    $this->setValidators(array(
        'email' => new sfValidatorEmail(),
        'first_name' => new sfValidatorString(),
        'last_name' => new sfValidatorString(),
    ));
    
    $guardUser = $this->getUser()->getGuardUser();
    
    $this->setDefault('email', $guardUser->getEmailAddress());
    $this->setDefault('first_name', $guardUser->getFirstName());
    $this->setDefault('last_name', $guardUser->getLastName());
    
    $this->widgetSchema->setNameFormat('test_send[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
  }
  
  public function save($con = null)
  {
    $messageCenterId = $this->getRequest()->getParameter('id');
    ArtSimpleMessenger::sendNewsletterToEmail($messageCenterId, $this->values['email'], $this->values['first_name'], $this->values['last_name']);
  }
}
